import { Avatar, Button, Card, Typography, Chip, Box as MuiBox, CardContent } from '@mui/material'
import { Box } from '@mui/system'
import React from 'react'
import PersonIcon from '@mui/icons-material/Person'
import GroupIcon from '@mui/icons-material/Group'
import { TeamBasicDTO } from '@/shared/types/client'

interface TeamsCardProps {
  teams?: TeamBasicDTO[];
}

const TeamsCard: React.FC<TeamsCardProps> = ({ teams = [] }) => {
    if (!teams || teams.length === 0) {
        return (
            <Card sx={{ 
                borderRadius: 2, 
                height: '100%', 
                width: "100%",
                boxShadow: 2,
                background: 'linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%)',
                border: '1px solid',
                borderColor: 'grey.200'
            }}>
                <CardContent sx={{ p: 3 }}>
                    <Typography 
                        variant="h6" 
                        sx={{ 
                            mb: 3, 
                            fontWeight: 600,
                            color: 'primary.main',
                            display: 'flex',
                            alignItems: 'center',
                            gap: 1
                        }}
                    >
                        <Box
                            sx={{
                                width: 8,
                                height: 8,
                                borderRadius: '50%',
                                bgcolor: 'primary.main'
                            }}
                        />
                        Mes équipes
                    </Typography>
                    
                    <Box sx={{ 
                        display: 'flex', 
                        flexDirection: 'column', 
                        alignItems: 'center', 
                        justifyContent: 'center',
                        height: 'calc(100% - 80px)',
                        color: 'text.secondary',
                        p: 3
                    }}>
                        <GroupIcon sx={{ fontSize: 48, mb: 2, opacity: 0.5 }} />
                        <Typography variant="body1" sx={{ textAlign: 'center', fontWeight: 500 }}>
                            Aucune équipe assignée
                        </Typography>
                        <Typography variant="body2" sx={{ textAlign: 'center', mt: 1 }}>
                            Vous n&apos;êtes actuellement membre d&apos;aucune équipe
                        </Typography>
                    </Box>
                </CardContent>
            </Card>
        )
    }

    return (
        <Card sx={{ 
            borderRadius: 2, 
            height: '100%', 
            width: "100%",
            boxShadow: 2,
            background: 'linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%)',
            border: '1px solid',
            borderColor: 'grey.200'
        }}>
            <CardContent sx={{ p: 3 }}>
                <Typography 
                    variant="h6" 
                    sx={{ 
                        mb: 3, 
                        fontWeight: 600,
                        color: 'primary.main',
                        display: 'flex',
                        alignItems: 'center',
                        gap: 1
                    }}
                >
                    <Box
                        sx={{
                            width: 8,
                            height: 8,
                            borderRadius: '50%',
                            bgcolor: 'primary.main'
                        }}
                    />
                    Mes équipes
                </Typography>

                <Box sx={{ display: 'flex', flexDirection: 'column', gap: 3 }}>
                    {teams.map((team, index) => (
                        <Box 
                            key={team.id} 
                            sx={{ 
                                p: 2.5, 
                                bgcolor: 'grey.50',
                                borderRadius: 2,
                                border: '1px solid',
                                borderColor: 'grey.200',
                                transition: 'all 0.2s ease',
                                '&:hover': {
                                    bgcolor: 'grey.100',
                                    borderColor: 'primary.light',
                                    boxShadow: 1
                                }
                            }}
                        >
                            <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                <Avatar 
                                    sx={{ 
                                        width: 40, 
                                        height: 40, 
                                        mr: 2,
                                        bgcolor: 'primary.main',
                                        fontSize: '1rem',
                                        fontWeight: 'bold'
                                    }}
                                >
                                    {team.name.charAt(0).toUpperCase()}
                </Avatar>
                                
                                <Box sx={{ flex: 1 }}>
                                    <Typography variant="subtitle1" sx={{ fontWeight: 600, color: 'text.primary' }}>
                                        {team.name}
                                    </Typography>
                                    <Typography variant="body2" color="text.secondary" sx={{ mt: 0.5 }}>
                                        Membre de l&apos;équipe
                                    </Typography>
                                </Box>
                            </Box>
                        </Box>
                    ))}
            </Box>

                {teams.length > 0 && (
                    <Box sx={{ 
                        mt: 3, 
                        textAlign: 'center'
                    }}>
                        <Typography variant="body2" color="text.secondary">
                            {teams.length} équipe{teams.length > 1 ? 's' : ''} au total
                        </Typography>
                    </Box>
                )}
            </CardContent>
        </Card>
    )
}

export default TeamsCard
