
'use client'
import { IPassword } from "@/shared/types/password";
import PasswordForm from "../components/password-form";
import { useSnackbar } from 'notistack'; // Importation de useSnackbar
import { useCollaboratorStore } from "@/shared/api/stores/CollaboratorStore";

export default function PasswordProfileView() {
    const { changeCollaboratorPassword,error } = useCollaboratorStore(); // Accède à la méthode du store
    const { enqueueSnackbar } = useSnackbar(); // Hook pour afficher les messages de notification

    const handleSave = async (values: IPassword) => {
            const userEmail = localStorage.getItem('userEmail');
            if (!userEmail) {
                enqueueSnackbar("L'email de l'utilisateur est manquant", { variant: 'error' });
                return;
            }

            await changeCollaboratorPassword({
                userName: userEmail, 
                oldPassword: values.currentPassword, 
                newPassword: values.newPassword, 
            });
    };

    return (
        <PasswordForm 
            onSave={handleSave}
            onClose={() => console.log('Fermeture')}
        />
    );
}

