import React from 'react';
import LaptopMacIcon from '@mui/icons-material/LaptopMac';
import ComputerIcon from '@mui/icons-material/Computer';
import MobileIcon from '@mui/icons-material/PhoneIphone';
import TabletIcon from '@mui/icons-material/Tablet';

export const getTimeAgo = (date: Date): string => {
  const now = new Date();
  const diffMs = now.getTime() - date.getTime();
  const diffMins = Math.round(diffMs / 60000);
  const diffHours = Math.round(diffMins / 60);
  const diffDays = Math.round(diffHours / 24);
  const diffMonths = Math.round(diffDays / 30);

  if (diffMins < 60) {
    return `${diffMins} minute${diffMins !== 1 ? 's' : ''}`;
  } else if (diffHours < 24) {
    return `${diffHours} heure${diffHours !== 1 ? 's' : ''}`;
  } else if (diffDays < 30) {
    return `${diffDays} jour${diffDays !== 1 ? 's' : ''}`;
  } else {
    return `${diffMonths} mois`;
  }
};

export const getDeviceIcon = (deviceType: string) => {
  switch (deviceType) {
    case 'mac':
      return <LaptopMacIcon sx={{ mr: 1 }} />;
    case 'windows':
      return <ComputerIcon sx={{ mr: 1 }} />;
    case 'mobile':
      return <MobileIcon sx={{ mr: 1 }} />;
    case 'tablet':
      return <TabletIcon sx={{ mr: 1 }} />;
    default:
      return <ComputerIcon sx={{ mr: 1 }} />;
  }
};

export const getDeviceDisplay = (device: { type: string; browser: string }): string => {
  return `${device.type.charAt(0).toUpperCase() + device.type.slice(1)} - ${device.browser}`;
};