import React, { useEffect } from 'react';
import TableManager from '../../../components/table/table-manager';
import { TableColumn } from '@/shared/types/common';
import HistoriqueTrajetTableRow from '../view/trajet-table-row';
import { TripDTO } from '@/shared/types/circuit';

interface TrajetTableProps {
  filteredData: TripDTO[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleView: (trajetId: string) => void;
  isSecondaryTable?: boolean
  onStatusChange: (row: TripDTO, newStatus: string, field: keyof TripDTO) => void;
  loading?: boolean;
  totalElements?: number;
}

export default function TrajetTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleView,
  isSecondaryTable,
  onStatusChange,
  loading,
  totalElements

}: TrajetTableProps) {


  const renderRow = (row: TripDTO) => {

    return (
      <HistoriqueTrajetTableRow
        dense={table.dense}
        key={row.id}
        row={row}
        handleDetailsContract={(trajet) => {
          handleView(trajet.id);
        }}
        columns={tableHead.slice(0, -2)}
        onStatusChange={onStatusChange}
      />
    );
  };

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
      loading={loading}
      sx={isSecondaryTable ? { backgroundColor: 'primary.lighter' } : undefined}
      count={totalElements}
    />
  );
}

