import type { Address } from "@/shared/types/establishment"
import type { AddressData } from "@/shared/types/common"

/**
 * Convertit une adresse du frontend (type AddressData) vers le format backend (Address)
 * @param addressData - L'adresse du frontend
 * @returns L'adresse au format backend
 */
export function convertAddressDataToAddress(addressData: AddressData): Address {
  if (!addressData) return {} as Address;
  return {
    latitude: addressData.lat,
    longitude: addressData.lng,
    street: addressData.address,
    city: addressData.city,
    zipCode: addressData.postalCode,
    country: addressData.country,
    additionalAddress: addressData.formattedAddress,
    addressType: undefined,
  }
}