import { WeekSchedule } from "@/shared/components/form/etablissement-jours-field";

export function convertWeekSchedules(
  weekSchedules: WeekSchedule[]
): {
  pair: { [key: string]: { all: boolean; ret: boolean } };
  impair: { [key: string]: { all: boolean; ret: boolean } };
} {
  const daysMap: Record<string, string> = {
    MONDAY: 'lundi',
    TUESDAY: 'mardi',
    WEDNESDAY: 'mercredi',
    THURSDAY: 'jeudi',
    FRIDAY: 'vendredi',
    SATURDAY: 'samedi',
    SUNDAY: 'dimanche',
  };

  const result = {
    pair: {},
    impair: {},
  } as {
    pair: { [key: string]: { all: boolean; ret: boolean } };
    impair: { [key: string]: { all: boolean; ret: boolean } };
  };

  weekSchedules.forEach((week) => {
    const target = week.weekType === 'EVEN' ? result.pair : result.impair;

    week.schedules.forEach((schedule) => {
      const day = daysMap[schedule.dayOfWeek];
      if (!target[day]) {
        target[day] = { all: false, ret: false };
      }

      if (schedule.periodOfDay === 'MORNING') {
        target[day].all = true;
      } else if (schedule.periodOfDay === 'EVENING') {
        target[day].ret = true;
      }
    });
  });

  return result;
}
