import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import { useTheme } from '@mui/material/styles';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import { dateFormat, formatDate } from '@/utils/format-time';
import { TripDTO, TripType } from '@/shared/types/circuit';
import { ContratStyledRow, getStatusColor, StatusChip } from '../../contract/styles';
import { _BINARY_Qst, _TRAJET_ETAT, _TRAJET_TYPE } from '@/shared/_mock/_trajets';
import TableActionColumn from '@/shared/components/table/table-action-column';
import StatusMenu from '@/shared/components/table/StatusMenu';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import { Box } from '@mui/material';


type Props = {
  handleDetailsContract: (trajet: TripDTO) => void;
  row: TripDTO;
  dense: boolean;
  columns: TableColumn[];
  onStatusChange: (row: TripDTO, newStatus: string, field: keyof TripDTO) => void;
};
const TOOLTIP_TITLES = {
  duplicate: 'Copier trajet',
  active: 'Trajet Actif',
  inactive: 'Trajet Inactif',
};
export default function HistoriqueTrajetTableRow({
  dense,
  row,
  handleDetailsContract,
  columns,
  onStatusChange,
}: Props) {
  const theme = useTheme();


  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'startDate':
      case 'createdAt':
        return formatDate(value, dateFormat.isoDate);
      case 'circuitState':
        const getStatusConfig = (
          status: string
        ): { label: string; backgroundColor: string; color: string } => {
          switch (status) {
            case 'CONTROLLED':
              return {
                label: 'Contrôlé',
                backgroundColor: '#E9FBF0',
                color: '#36B37E',
              };
            case 'UNCONTROLLED':
              return {
                label: 'Non contrôlé',
                backgroundColor: '#FFE1E1',
                color: '#FF3434',
              };
            case 'ON_HOLD':
              return {
                label: 'En attente',
                backgroundColor: '#FEF8E7',
                color: '#F9B90B',
              };
            case 'UPDATED':
              return {
                label: 'Mis à jour',
                backgroundColor: '#EEF1FF',
                color: '#5176FE',
              };
            default:
              return {
                label: value,
                backgroundColor: '#F4F6F8',
                color: '#637381',
              };
          }
        };

        const statusConfig = getStatusConfig(value);
        return (
          <StatusChip
            label={statusConfig.label}
            status={value}
            theme={theme}
            size="small"
            sx={{
              backgroundColor: statusConfig.backgroundColor,
              color: statusConfig.color,
              fontWeight: 500,
            }}
          />
        );
      case 'isRotation':
        const getRotationConfig = (value: boolean) => {
          return {
            label: value ? 'Oui' : 'Non',
            backgroundColor: value ? '#E9FBF0' : '#FFE1E1',
            color: value ? '#36B37E' : '#FF3434',
          };
        };
        const rotationConfig = getRotationConfig(value);
        return (
          <StatusChip
            label={rotationConfig.label}
            status={value ? 'Oui' : 'Non'}
            theme={theme}
            size="small"
            sx={{
              backgroundColor: rotationConfig.backgroundColor,
              color: rotationConfig.color,
              fontWeight: 500,
            }}
          />
        );
      case 'hasTolls':
        const getTollsConfig = (value: boolean) => {
          return {
            label: value ? 'Oui' : 'Non',
            backgroundColor: value ? '#E9FBF0' : '#FFE1E1',
            color: value ? '#36B37E' : '#FF3434',
          };
        };
        const tollsConfig = getTollsConfig(value);
        return (
          <StatusChip
            label={tollsConfig.label}
            status={value ? 'Oui' : 'Non'}
            theme={theme}
            size="small"
            sx={{
              backgroundColor: tollsConfig.backgroundColor,
              color: tollsConfig.color,
              fontWeight: 500,
            }}
          />
        );
      case 'tripDirection':
        const firstLetter = value.charAt(0).toUpperCase();
        const label = firstLetter === 'D' ? 'A' : firstLetter;
        return (
          <StatusChip
            label={label}
            status={value}
            theme={theme}
            size="small"
            sx={{
              backgroundColor: '#F4F6F8',
              color: '#637381',
              fontWeight: 'bold',
            }}
          />
        );
      case 'tripType':
        const getTripTypeConfig = (value: string) => {
          switch (value) {
            case 'NORMAL':
              return {
                label: 'Trajet Normal',
                backgroundColor: '#F4F6F8',
                color: '#637381',
              };
            case 'PERSONALIZED':
              return {
                label: 'Trajet Personnalisé',
                backgroundColor: '#F4F6F8',
                color: '#637381',
              };
            default:
              return {
                label: value,
                backgroundColor: '#F4F6F8',
                color: '#637381',
              };
          }
        };
        const tripTypeConfig = getTripTypeConfig(value);
        return (
          <StatusChip
            label={tripTypeConfig.label}
            status={value}
            theme={theme}
            size="small"
            sx={{
              backgroundColor: tripTypeConfig.backgroundColor,
              color: tripTypeConfig.color,
              fontWeight: 500,
            }}
          />
        );
      default:
        return value;
    }
  };

  return (
    <ContratStyledRow
      sx={{
        backgroundColor: row.tripType === TripType.PERSONALIZED ? '#FEF8E7' : '',
      }}
      hover
      style={{ cursor: 'pointer' }}
    >
      {columns.map((column: any, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetailsContract(row)}
          key={column.id}
          align={column.align}
          sx={{
            whiteSpace: 'nowrap',
            py: column.id === 'circuitState' ? 0.2 : dense ? 0 : 1,
            ...(index === 0 && {
              position: 'relative',
            }),
          }}
        >
          <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{
                position: 'absolute',
                top: 0,
                left: -4,
                height: '100%',
                color: row.colorCode || getStatusColor(row.circuitState),
              }}
            />
          </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof TripDTO])}
        </TableCell>
      ))}
      <TableCell align="right" sx={{ px: 1, whiteSpace: 'nowrap' }}>
          <TableActionColumn
            onToggle={(checked) => void 0}
            isActive={row.isActive}
            tooltipTitles={TOOLTIP_TITLES}
            disabled={true}
          />
        </TableCell>
    </ContratStyledRow>
  );
}
