import type { EstablishmentHoursResponse, EstablishmentRequest, UpdateEstablishmentHoursRequest } from "@/shared/types/establishment"
import { DayOfWeek } from "@/shared/types/establishment"

/**
 * Convertit un tableau de EstablishmentHoursResponse en EstablishmentRequest
 * pour remplir le formulaire Formik
 */
export function convertHoursResponseToRequest(hoursArray: EstablishmentHoursResponse[]): EstablishmentRequest {
    const request: UpdateEstablishmentHoursRequest = {
        mondayMorningOpeningTime: "",
        mondayEveningClosingTime: "",
        tuesdayMorningOpeningTime: "",
        tuesdayEveningClosingTime: "",
        wednesdayMorningOpeningTime: "",
        wednesdayEveningClosingTime: "",
        thursdayMorningOpeningTime: "",
        thursdayEveningClosingTime: "",
        fridayMorningOpeningTime: "",
        fridayEveningClosingTime: "",
        saturdayMorningOpeningTime: "",
        saturdayEveningClosingTime: "",
        sundayMorningOpeningTime: "",
        sundayEveningClosingTime: "",
    }

    hoursArray.forEach((hours) => {
        const dayLower = hours.dayOfWeek.toLowerCase()

        switch (hours.dayOfWeek) {
            case DayOfWeek.MONDAY:
                request.mondayMorningOpeningTime = hours.morningOpeningTime || ""
                request.mondayEveningClosingTime = hours.eveningClosingTime || ""
                break
            case DayOfWeek.TUESDAY:
                request.tuesdayMorningOpeningTime = hours.morningOpeningTime || ""
                request.tuesdayEveningClosingTime = hours.eveningClosingTime || ""
                break
            case DayOfWeek.WEDNESDAY:
                request.wednesdayMorningOpeningTime = hours.morningOpeningTime || ""
                request.wednesdayEveningClosingTime = hours.eveningClosingTime || ""
                break
            case DayOfWeek.THURSDAY:
                request.thursdayMorningOpeningTime = hours.morningOpeningTime || ""
                request.thursdayEveningClosingTime = hours.eveningClosingTime || ""
                break
            case DayOfWeek.FRIDAY:
                request.fridayMorningOpeningTime = hours.morningOpeningTime || ""
                request.fridayEveningClosingTime = hours.eveningClosingTime || ""
                break
            case DayOfWeek.SATURDAY:
                request.saturdayMorningOpeningTime = hours.morningOpeningTime || ""
                request.saturdayEveningClosingTime = hours.eveningClosingTime || ""
                break
            case DayOfWeek.SUNDAY:
                request.sundayMorningOpeningTime = hours.morningOpeningTime || ""
                request.sundayEveningClosingTime = hours.eveningClosingTime || ""
                break
        }
    })

    return request as EstablishmentRequest;
} 
