import { IPassengerList } from '@/shared/types/passenger';
import { TabConfig, useTabsManager } from '../../../../hooks/use-tabs-manager';
import { INITIAL_USAGER_DATA } from '@/shared/_mock/_usagers';
import { TableType } from '@/shared/types/common';

const contractConfig: TabConfig<IPassengerList> = {
  type: TableType.Usager,
  listTitle: 'Liste des usagers',
  newItemTitle: 'nouvel usager',
  initialData: INITIAL_USAGER_DATA,
  getItemCode: (usager) => usager.firstName+' '+usager.lastName, 
};

export function useUsagerTabs() {
  return useTabsManager<IPassengerList>(contractConfig);
}

