import type React from 'react';
import type { ModeType } from '@/shared/types/common';
import type { Representative } from '@/shared/types/passenger';

export interface RepresentantFormProps {
  tabId?: number;
  representatives?: Representative[];
  trajectorySchedules?: {
    pair: { [key: string]: { all: boolean; ret: boolean } };
    impair: { [key: string]: { all: boolean; ret: boolean } };
  };
  isUsagerAttachedToAmendment?: boolean;
  data: Representative;
  isReadOnly: boolean;
  onChange: (newData: Partial<Representative>) => void;
  tabIndex: number;
  mode: ModeType;
  handleTabClose: (event: React.MouseEvent, tabId: number) => void;
  variant: 'standard' | 'amendment';
}

export interface UseRepresentantFormProps {
  mode: ModeType;
  data: Representative;
  variant: 'standard' | 'amendment';
  tabIndex: number;
  onChange: (newData: Partial<Representative>) => void;
}

export const disabledFields = ['firstName', 'lastName', 'addresses', 'circuitId'];

export const typeMap = {
  mobilePhoneNumbers: 'mobile',
  landlinePhoneNumbers: 'fixe',
  assignedPersonNames: 'personne',
} as const;

export const variantConfig = {
  standard: {
    formikPath: 'representatives',
    contextType: 'IPassengerList' as const,
  },
  amendment: {
    formikPath: 'amendmentRepresentatives',
    contextType: 'AmendmentPassengerDetails' as const,
  },
} as const;
