import { ActionType, AmendmentPassengerDetails } from '@/shared/types/ammendment-passenger';
import { FormFieldType } from '@/shared/types/common';
import { IAvenantUsager } from '@/shared/types/usager';
import {
    faStickyNote,
    faListUl,
    faKeyboard,
    faGear,
  } from '@fortawesome/free-solid-svg-icons'
import { FormikAmendmentPassengerDetails } from '../components/usager-form/avenants-horaires/types/formik-types';
  
const ACTION_AVENANT_OPTIONS = [
  { value: ActionType.ADD_PASSENGER, label: 'Ajout usager' },
  { value: ActionType.REMOVE_PASSENGER, label: 'Suppression usager' },
  { value: ActionType.SCHEDULE_CHANGE, label: 'Modification horaire' },
  { value: ActionType.USER_ADDRESS_CHANGE, label: 'Modification adresse' },
  { value: ActionType.CIRCUIT_CHANGE, label: 'Changement circuit' },
  { value: ActionType.ESTABLISHMENT_CHANGE, label: 'Modification établissement' }
];

export const usagerAvenantFormFields1=(
  etablissementOptions: { value: string; label: string }[],
  searchEstablishments: (query?: string) => void,
) : FormFieldType<FormikAmendmentPassengerDetails & {etablissement: string}>[] => [
  {
    name: 'startDate',
    label: 'Début de transport',
    type: 'date',
    required: true,
    disabled: true,
  },
  {
    name: 'endDate',
    label: 'Au / Avenant temporaire/Stage',
    type: 'date',
    required: true,
    disabled: true,
  },
  {
    name: 'subject',
    label: 'Objet de l\'avenant',
    placeholder: 'Entrez l\'objet',
    type: 'text',
    icon: faKeyboard,
    required: true,
  },
  {
    name: 'etablissement',
    label: 'Etablissement',
    placeholder: 'Choisissez un nom',
    type: 'combobox',
    options: etablissementOptions,
    onSearch: searchEstablishments,
    required: true,
    disabled: true
  },
  {
    name: 'actionType',
    label: 'Action avenant',
    type: 'select',
    options: ACTION_AVENANT_OPTIONS,
    icon: faGear,
    disabled: true
  },
]

export const usagerAvenantFormFields2: FormFieldType<FormikAmendmentPassengerDetails>[] = [
  {
    name: 'specificity',
    label: 'Spécificité',
    placeholder: 'Entrez un texte',
    type: 'text',
    icon: faListUl,
  },
  {
    name: 'observation',
    label: 'Observation',
    placeholder: 'Ajoutez une note ou une observation',
    type: 'textarea',
    icon: faStickyNote,
  },
]
  