import { _CIRCUIT_STATUS } from '@/shared/_mock/_circuit';
import { _BINARY_Qst, _TRAJET_ETAT, _TRAJET_TYPE } from '@/shared/_mock/_trajets';
import { _SENS_AR } from '@/shared/_mock';
import { _classes } from '@/shared/_mock/_usagers';
import { FormFieldType } from '@/shared/types/common';
import {
  PassengerCivility,
  IPassengerList,
  SchoolClass,
  CustodyCategory,
  ParticularityTransport,
  _PassengerStatus,
  RelationType,
} from '@/shared/types/passenger';
import { DatePickerFormat } from '@/utils/format-time';
import {
  faUserTie,
  faMagnifyingGlassLocation,
  faListUl,
  faStickyNote,
  faEnvelope,
} from '@fortawesome/free-solid-svg-icons';
import dayjs from 'dayjs';
import { toTitleCase } from '@/utils/helper';

export const _classesOptions = Object.values(SchoolClass).map((className) => ({
  value: className,
  label: className.length > 3 ? toTitleCase(className) : className,
}));

const _custodyCategoryOptions = [
  { value: CustodyCategory.ALTERNATING_CUSTODY, label: 'Garde alternée' },
  { value: CustodyCategory.RETURNS_AT_NOON, label: 'Retour à midi' },
];

export const _particularityTransportOptions = [
  { value: ParticularityTransport.AUTISME, label: 'Autisme' },
  { value: ParticularityTransport.DEFICIENT_VISUEL, label: 'Déficient visuel' },
  { value: ParticularityTransport.FAUTEUIL_ELECTRIQUE, label: 'Fauteuil électrique' },
  { value: ParticularityTransport.FAUTEUIL_ELECTRIQUE_103, label: 'Fauteuil électrique 103' },
  { value: ParticularityTransport.FAUTEUIL_MANUEL, label: 'Fauteuil manuel' },
  {
    value: ParticularityTransport.FAUTEUIL_MANUEL_TRANSFERABLE,
    label: 'Fauteuil manuel transferable',
  },
  { value: ParticularityTransport.FAUTEUIL_PLIANT, label: 'Fauteuil pliant' },
  { value: ParticularityTransport.GILLES_DE_LA_TOURETTE, label: 'Gilles de la Tourette' },
  { value: ParticularityTransport.MALVOYANT, label: 'Malvoyant' },
  { value: ParticularityTransport.MARCHANT, label: 'Marchant' },
  { value: ParticularityTransport.MOBILITE_REDUITE, label: 'Mobilité réduite' },
  { value: ParticularityTransport.NON_TRANSFERABLE, label: 'Non transferable' },
  { value: ParticularityTransport.PERSONNE_AGEE, label: 'Personne âgée' },
  { value: ParticularityTransport.TRANSFERABLE, label: 'Transferable' },
  { value: ParticularityTransport.TRANSPORT_INDIVIDUALISE, label: 'Transport individualisé' },
  { value: ParticularityTransport.TRISOMIE_21, label: 'Trisomie 21' },
];

export function calculateAge(birthDate: DatePickerFormat): number | null {
  if (!birthDate) return null;
  const today = dayjs();
  const birthDayjs = dayjs(birthDate);
  if (!birthDayjs.isValid()) return null;

  let age = today.year() - birthDayjs.year();
  const monthDiff = today.month() - birthDayjs.month();

  if (monthDiff < 0 || (monthDiff === 0 && today.date() < birthDayjs.date())) {
    age--;
  }

  return age;
}

export const _CIVILITE = [
  { value: PassengerCivility.MR, label: 'M.' },
  { value: PassengerCivility.MME, label: 'Mme' },
];

export const mainPassengerFormFields: FormFieldType<IPassengerList>[] = [
  {
    name: 'civility',
    label: 'Civilité',
    type: 'checkbox',
    options: _CIVILITE,
  },
  {
    name: 'lastName',
    label: 'Nom',
    placeholder: 'Entrez un Nom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'firstName',
    label: 'Prénom',
    placeholder: 'Entrez un Prénom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
];

export const getPassengerFormFields = (
  etablissementOptions: { value: string; label: string }[],
  departmentOptions: { value: string; label: string }[],
  getEstablishments: (query?: string) => void,
): FormFieldType<IPassengerList>[] => [
  {
    name: 'state',
    label: 'État',
    type: 'select',
    options: _PassengerStatus,
  },
  {
    name: 'email',
    label: 'E-mail',
    placeholder: 'Entrez un e-mail',
    type: 'text',
    required: true,
    icon: faEnvelope,
  },
  {
    name: 'birthDate',
    label: 'Date de naissance',
    type: 'date',
    placeholder: 'JJ/MM/AAAA',
    required: true,
  },
  {
    name: 'birthPlace',
    label: 'Lieu de naissance',
    placeholder: 'Entrer un lieu de naissance',
    type: 'text',
    icon: faMagnifyingGlassLocation,
  },
  {
    name: 'startTransport',
    label: 'Début du transport',
    type: 'date',
    required: true,
  },
  {
    name: 'idDepartment',
    label: 'Département',
    type: 'combobox',
    options: departmentOptions,
    required: true,
    hasAddInfrastructureModal : true
  },
  {
    name: 'establishmentTransportSchedules',
    label: 'Établissement',
    type: 'combobox',
    options: etablissementOptions,
    onSearch: getEstablishments,
    required: true,
    hasAddEstablishmentModal : true
  },
  {
    name: 'schoolClass',
    label: 'Classe',
    type: 'select',
    options: _classesOptions,
  },
  {
    name: 'particularityTransport',
    label: 'Particularité de transport',
    type: 'select',
    options: _particularityTransportOptions,
  },
  {
    name: 'specificity',
    label: 'Spécificité',
    type: 'text',
    placeholder: 'Entrez une spécificité',
    icon: faListUl,
  },
  {
    name: 'custodyCategory',
    label: 'catégorie',
    type: 'select',
    options: _custodyCategoryOptions,
  },
  {
    name: 'referentTeacherName',
    label: 'Enseig. référent',
    type: 'text',
    placeholder: 'Entrez un texte',
    icon: faUserTie,
  },
  {
    name: 'observations',
    label: 'Observations',
    type: 'textarea',
    placeholder: 'Ajoutez une note ou une observation',
    icon: faStickyNote,
  },
];

export const _RELATION_TYPE_OPTIONS = [
  { value: RelationType.MOTHER, label: 'Mère' },
  { value: RelationType.FATHER, label: 'Père' },
  { value: RelationType.PARENT, label: 'Parent' },
  { value: RelationType.GRANDPARENT, label: 'Grand-parent' },
  { value: RelationType.GROUP_HOME, label: 'Foyer' },
  { value: RelationType.MEDICAL_FACILITY, label: 'Établissement médical' },
  { value: RelationType.OTHER, label: 'Autre' },
];
