import { StatusColor } from "../sections/chauffeur/planingChauffeur/utils/schedule-utils"
import { GeolocStatus } from "./geoloc"

export interface LatLng {
  lat: number
  lng: number
}

export type MarkerType = "start" | "end" | "vehicle" | "user" | string

export interface RouteMarker {
  id: MarkerType
  position: LatLng
  title: string
  icon: string
  color?: StatusColor
  routeIndex?: number
  isVisited?: boolean

}

export interface User {
  position: LatLng
  title: string
}

export interface CircuitMap {
  id: string
  name: string
  startPoint?: {
    position: LatLng
    title: string
  }
  endPoint?: {
    position: LatLng
    title: string
  }
  path?: LatLng[]
  users?: User[]
  tolls?: User[]
  color:StatusColor
  status?: GeolocStatus
  departement?: string
  routes?: RouteMarker[]
  isSelected?: boolean
  vehicule?: string
  departurePoint?: string
  arrivalPoint?: string
  departureDate?: string
  arrivalDate?: string
  startTime?: string
  endTime?: string
  pickups?: Pickup[]
  currentVehiclePosition?: VehiclePosition;
  prenomChauffeur?: string;
  nomChauffeur?: string;
  vehiculeId?: string;
}
export interface Pickup {
  position: LatLng
  title: string
}

export enum MapType {
  DRIVER = 'chauffeur',
  PASSENGER = 'usager',
  CIRCUIT = 'circuit',
  GEOLOC = 'geoloc',
}
export enum VehicleStatus {
  ON_TIME = 'ON_TIME',
  DELAYED = 'DELAYED',
  STOPPED = 'STOPPED',
  COMPLETED = 'COMPLETED'
}


export interface VehiclePosition {
  lat: number;
  lng: number;
  rotation: number;
  vehicleType: string;
}

