import { ModeType } from '@/shared/types/common';
import { DriverAbsenceStatus } from '@/shared/types/driver-absence';

// DTO for creating absence requests
export interface CreateAbsenceDto {
  userId: number;
  absenceType: string;
  startDate: string;
  endDate: string;
  numberOfDays: number;
  justificationFileUrl: string | null;
  authorizedBy: string | null;
  validatedBy: string | null;
  hoursCount: number;
  receivingMethod: string;
  state: string;
  observations?: string | null;
  comment?: string | null;
  requestType: string;
  affectedToTrip: boolean;
  tripsIds: any[];
}


export interface User {
  firstName: string;
  lastName: string;
  departmentName?: string;
  functionType?: string;
}

// Updated IRHAbsence interface to match backend response
export interface IRHAbsence {
  id: string;
  absenceNumber?: string;
  userId: number;
  user?: User;
  functionType?: string;
  absenceType?: string;
  leaveType?: string;
  requestType?: string;
  startDate: string;
  endDate: string;
  numberOfDays: number;
  hoursCount?: number;
  justificationFileUrl?: string | null;
  submittedAt?: string;
  processedAt?: string | null;
  state: string;
  authorizedBy?: string | null;
  authorizedByName?: string | null;  // ✅ ADD THIS
  validatedBy?: string | null;
  validatedByName?: string | null;   // ✅ ADD THIS
  receivingMethod?: string;
  affectedToTrip?: boolean;
  rhComment?: string | null;
  createdByRh?: boolean;
  tripsIds?: any[];
  observations?: string;
  forecastDate?: string;
  comment?: string;
  
  // Legacy frontend fields for table compatibility
  numeroEnregistrement?: string;
  nomChauffeur?: string;
  typeAbsence?: string;
  typeAbsenceLabel?: string;
  dateDebut?: string;
  dateFin?: string;
  statut?: string;
  justificatif?: string;
  modeReception?: string;
  nbrHeures?: number;
  validerPar?: string;
  autorisePar?: string;
  departement?: string;
  type?: 'chauffeur' | 'sédentaire';
  affecteTrajet?: string | boolean;
  mode?: ModeType;
}

// State constants for treated and non-treated absences
export const TREATED_STATES = ['Approved', 'Rejected', 'Cancelled', 'Processed'];
export const NON_TREATED_STATES = ['Untreated', 'NON_TRAITE', 'In_progress', 'Unprocessed', 'Waiting'];

export interface RHAbsenceTableRowProps<T> {
  row: T;
  dense: boolean;
  selected: boolean;
  onSelectRow: () => void;
  handleEdit: (item: T) => void;
  handleDetails: (item: T) => void;
  columns: any[];
  onStatusChange?: (row: T, newStatus: string, field: keyof T) => void;
  isTraiteTable?: boolean;
}

export interface RHAbsenceFormProps {
  absence: IRHAbsence;
  mode: ModeType;
  onSave: (updatedAbsence: IRHAbsence) => void;
  onEdit: (updatedAbsence: IRHAbsence) => void;
  onClose: () => void;
  isTraiteAbsence?: boolean;
}

export interface UserOption {
  id: string;
  label: string;
  firstName: string;
  lastName: string;
  email: string;
  phoneNumber?: string;
  departmentName?: string;
  type: 'CHAUFFEUR' | 'SEDENTAIRE';
}

export interface DriverShort {
  id: string;
  firstName: string;
  lastName: string;
  email: string;
  phoneNumber?: string;
  departmentName?: string;
}

export interface CollaboratorShort {
  id: string;
  firstName: string;
  lastName: string;
  email: string;
  phoneNumber?: string;
  departmentName?: string;
} 