import { Pageable } from './client';

// Basic amendment list item
export interface AmendmentListDTO {
  id: string;
  applicationDate: string;
  status: string;
  circuitCode: string;
  amendmentCode: string;
  title: string;
  amendmentPurpose: string;
  type: string;
  endDate: string;
  establishment: string;
  driver: string;
  company: string;
  clientDO: string;
  purpose: string;
  active: boolean;
  client: string;
  object: string;
  subject: string;
  createdAt: string;
  controlled: boolean;
  amendmentObject: string;


}

// API Response structure - matches actual API field names
export interface AmendmentApiResponse {
  id: string;
  applicationDate: string;
  status: string;
  circuitCode: string;
  amendmentCode: string;
  title: string;
  amendmentPurpose: string;
  type: string;
  endDate: string;
  establishment: string;
  driver: string;
  company: string;
  clientDO: string;
  purpose: string;
  coverage?: string;
  mainEstablishment?: string;
  calculationType?: string;
  pricingGrid?: string;
  categorizationColor?: string;
  observation?: string;
  active: boolean;
}

// Trip information
export interface TripDTO {
  // ✅ Current fields (working)
  id: string;
  direction: 'OUTBOUND' | 'RETURN';
  distance: number;
  duration: number;
  passengerCount: number;

  // ✅ All fields now provided by API
  tripNumber: string;      // Trip number (e.g., "000001")
  preparation: string;       // Preparation status ("YES" | "NO")
  startDate: string;         // Start date (ISO format)
  title: string;          // Trip title/description
  establishment: string;              // Establishment name
  circuitTripCode: string; // Circuit trip code (e.g., "EC-001-001")
  circuit: string;          // Circuit identifier (e.g., "2212")
  status: string;             // Trip status ("CONTROLLED" | "UNCONTROLLED")
  driver: string;        // Driver name
}

// Schedule information
export interface ScheduleDTO {
  id: string;
  tripId: string;
  day: string;
  departureTime: string;
  arrivalTime: string;
  capacity: number;
  direction: 'OUTBOUND' | 'RETURN';
  days: string;
  time: string;
  active: boolean;
  type: string;
  status: string;
}

// Detailed amendment information - matches actual API response structure
export interface AmendmentDetailDTO {
  amendment: AmendmentApiResponse;
  trips: TripDTO[];
  schedules: Pageable<ScheduleDTO>;
}

// Amendment search parameters
export interface AmendmentSearchParams {
  id?: string;
  amendmentCode?: string;
  amendmentType?: string;
  driver?: string;
  company?: string;
  controlled?: boolean;
  searchTerm?: string;
  sortBy?: string;
  sortDirection?: 'ASC' | 'DESC';
  page?: number;
  size?: number;
}

// Pageable response types
export interface AmendmentListPageable {
  content: AmendmentListDTO[];
  pageNumber: number;
  pageSize: number;
  totalElements: number;
  totalPages: number;
  first: boolean;
  last: boolean;
  empty: boolean;
}

export type TripListPageable = Pageable<TripDTO>;
export type ScheduleListPageable = Pageable<ScheduleDTO>;
