import { IBaseEntity } from "./client";
import { DaysOfWeek, ParticularityTransport, Representative, SensTrip } from "./passenger";

export interface AmendmentPassengerList extends IBaseEntity {
    observation: string;
    subject: string;
    startDate: string;
    circuitCode: string;
    circuitName: string;
}

export interface SearchPassengerAmendmentParams {
    passengerId: number;
    subject?: string;
    observation?: string;
    startDate?: string;
    page?: number;
    size?: number;
    sortBy?: string;
    sortDir?: 'ASC' | 'DESC';
}

export interface AmendmentPassengerDetails extends IBaseEntity {
    subject: string;
    observation: string;
    creationType: string;
    actionType: ActionType;
    startDate: string;
    endDate: string;
    amendmentType: string;

    specificity: string;
    passengerId: number;
    triggeredAmendmentCircuitId: string;

    passengerScheduleWeeks: PassengerScheduleWeekDTO[];
    establishmentWeekPassengerMap: IdWithTransportScheduleAmendmentsDTO[];
    amendmentRepresentatives : Representative[];
}
export interface IdWithTransportScheduleAmendmentsDTO {
    establishmentId: number;
    transportScheduleAmendments: TransportScheduleAmendmentDTO[];
}

export interface TransportScheduleAmendmentDTO extends IBaseEntityNullable {
    weekType: string;
    dayScheduleAmendment: ScheduleAmendmentDTO[];
}
export interface ScheduleAmendmentDTO {
    dayOfWeek: DaysOfWeek;
    periodOfDay: PeriodOfDay;
    isAssignmentDayInWeek: boolean;
}

export interface IBaseEntityNullable {
    id: string | null;
    createdAt?: string;
    updatedAt?: string;
  }
export interface PassengerScheduleWeekDTO extends IBaseEntityNullable {
    weekType: string;
    amendmentPassengerSchedule: AmendmentPassengerScheduleDTO[];
}

export enum TripDirection {
    DEPARTURE = 'DEPARTURE',
    RETURN = 'RETURN'
}
export interface AmendmentPassengerSchedule {
    tripDirection: TripDirection;
    dayOfWeek: DaysOfWeek;
    periodOfDay: PeriodOfDay;
    scheduledTime: string;
}

export interface ScheduleWeekDTO {
    sensTrip: SensTrip;
    dayOfWeek: DaysOfWeek;
    time: string;
}

export enum PeriodOfDay {
    MORNING = 'MORNING',
    EVENING = 'EVENING',
    MIDI = 'MIDI'
}

export enum ActionType {
    ADD_PASSENGER = 'ADD_PASSENGER',
    REMOVE_PASSENGER = 'REMOVE_PASSENGER',
    SCHEDULE_CHANGE = 'SCHEDULE_CHANGE',
    USER_ADDRESS_CHANGE = 'USER_ADDRESS_CHANGE',
    CIRCUIT_CHANGE = 'CIRCUIT_CHANGE',
    ESTABLISHMENT_CHANGE = 'ESTABLISHMENT_CHANGE'
}
export interface AmendmentPassengerScheduleDTO {
    sensTrip: SensTrip;
    dayOfWeek: DaysOfWeek;
    periodOfDay: PeriodOfDay;
    scheduledTime: string;
}

export interface AmendmentTripDTO extends IBaseEntityNullable {
    particularityTransport: ParticularityTransport;
    passengerScheduleWeeks: PassengerScheduleWeekDTO[];
}

export interface InitialAmendmentPassengerDTO extends IBaseEntity {
    startDate: string;
    endDate: string;
    passengerScheduleWeeks: PassengerScheduleWeekDTO[];
    establishmentWeekPassengerMap: IdWithTransportScheduleAmendmentsDTO[];
    amendmentRepresentatives : Representative[];
}