import { AddressData } from "./common";

export type CandidatStatus = 'Salarié' | 'Sorti' | 'Archivé';

export interface WorkingHours {
  day: number
  startHour: number
  endHour: number
}

export interface Candidat {
    id: string;
    numeroSalarié: string;
    civilite: 'M' | 'Mme' | 'Mlle';
    nom: string;
    nomFamille: string;
    prenom: string;
    villeNaissance: string;
    dateNaissance: string;
    nationalite: string;
    email: string;
    telephone: string;
    adresse: AddressData;
    codePostal: string;
    ville: string;
    dureePermis: string;
    numeroPermis: string;
    numeroSS: string;
    dateDebutContrat: string;
    dateSignatureContrat: string;
    dateInscription: string;
    status: CandidatStatus;
    tauxHoraire: number;
    cni: File | null;
    permisConduire: File | null;
    carteVitale: File | null;
    rib: File | null;
    type: 'sedentaire' | 'chauffeur';
    workingHours?: WorkingHours[]
    departement?: string;
    fuelCard:string[]
    // Additional fields from backend
    licensePath?: string;
    idCardPath?: string;
    healthCardPath?: string;
    bankDetailsPath?: string;
    profilePicturePath?: string;
    licenseUrl?: string;
    idCardUrl?: string;
    healthCardUrl?: string;
    bankDetailsUrl?: string;
    profilePictureUrl?: string;
    fullName?: string;
    // File objects for new uploads
    profilePictureFile?: File;
} 