import { RoleStatus } from '../api/stores/roleStore';
import { AddressData, Civility } from './common';
import { RoleModule } from './role';

export interface IBaseEntity {
  id: string;
  createdAt?: string;
  updatedAt?: string;
}
export interface IRole extends IBaseEntity {
  name: string;
  description: string;
  status?: RoleStatus;
  modules?: RoleModule[];
  permissions?: string[];
}
export interface IUser extends IBaseEntity {
  lastName: string;
  firstName: string;
  email: string;
  personalEmail?: string;
  birthDate?: string;
  birthPlace?: string;
  civility?: Civility;
  phoneNumber: string;
  password: string;
  userStatus?: UserStatus;
  photoUrl?: string;
  isArchived: boolean;
  addresses?: AddressDTO[];
  roles: IRole[];
  connectionHistory?:UserConnectionHistoryDto[];
}
export interface UserConnectionHistoryDto extends IBaseEntity {
  loginDateTime: Date;
  logoutDateTime: Date | null; 
  duration: number | null;     
}

export interface UpdatePasswordRequest {
  email: string;
  password: string;
}

export interface ChangePasswordRequest {
  userName: string;
  oldPassword: string;
  newPassword: string;
}

export interface SendingEmailRequest {
  email: string;
}
export interface UserConfirmationRequestOtp {
  email: string;
  confirmationCode: string;
  operationHash: string;
}

export interface UserPasswordCreationRequest {
  email: string;
  password: string;
  operationHash: string;
}

export enum CollaboratorStatus {
  APPROVED = 'Approuvé',
  PENDING = 'En attente',
  BANNED = 'Banni',
  DELETED='Supprimé'
}

export enum ContractType {
  CDI = 'CDI',
  CDD = 'CDD',
  INTERIM = 'INTERIM',
}
export interface TeamBasicDTO {
  id: number;
  name: string;
}
export interface CollaboratorExportFilterRequest {
  firstName?: string;
  lastName?: string;
  email?: string;
  phoneNumber?: string;
  address?: string;
  collaboratorStatus?: string; 
  role?: string;
}

export interface IAgent extends IUser {
  agentIdentifier: string;
  departmentId: number;
  departmentName: string;
  agencyId: number;
  agencyName: string;
  teams: TeamBasicDTO[];
  contractType: ContractType;
  socialSecurityNumber: string;
  collaboratorStatus: CollaboratorStatus;
  folderId?: number;
  permissions?: string[];
  mapAdresse?:AddressData;
  schedule?: WorkSchedule;
  skype?: string | null; // legacy
  outlook?: string | null;
  whatsapp?: string | null;
}

// Types pour l'emploi du temps
export interface WorkSchedule {
  id?: string | null;
  collaboratorId?: string | null;
  weeklySchedule: WeeklySchedule;
  createdAt?: string | null;
  updatedAt?: string | null;
}

export interface WeeklySchedule {
  id?: string | null;
  monday: DaySchedule;
  tuesday: DaySchedule;
  wednesday: DaySchedule;
  thursday: DaySchedule;
  friday: DaySchedule;
  saturday: DaySchedule;
  sunday: DaySchedule;
  createdAt?: string | null;
  updatedAt?: string | null;
}

export interface DaySchedule {
  id?: string | null;
  isWorkingDay: boolean;
  startTime?: string | null;
  endTime?: string | null;
  breakStartTime?: string | null;
  breakEndTime?: string | null;
  createdAt?: string | null;
  updatedAt?: string | null;
}

export interface IClient extends IUser {
  clientName?: string;
  landlinePhone?: string;
  mainBranch?: MainBranch;
  agencyName?:string;
  portalAssignment?: PortalAssignment;  
  signatureDate?: string;
  department:string;
  departmentId?: number;
  colorCode?: string;
  siret?: string;
  tva?: string;
  agency_id?: number;
  apeCode?: string;
  paymentDate?: string;
  observation?: string;
  bankName?: string;
  iban?: string;
  auxiliaryAccount?: string;
  salesAccount?: string;
  accountingAccount?: string;
  accountHolder?: string;
  accountAddress?: string;
  swiftBic?: string;
  typeClient?: 'CLIENT_DO' | 'OTHERS';
  mapAdresse?:AddressData;
}
export interface MapAddresse {
  address: string,
  lat: number,
  lng: number,
  city: string,
  postalCode: string,
  country: string,
  formattedAddress: string
}

export interface AddressDTO  extends IBaseEntity {

  latitude: number;
  longitude: number;
  street: string;
  city: string;
  country: string;
  zipCode: string;
  additionalAddress?: string;
  addressType: AddressType;  

}

  export interface ClientTypeDTO  extends IBaseEntity{
    name: string;
  }

  export enum AddressType {
    COLLABORATOR = 'COLLABORATOR',
    CLIENT = 'CLIENT',
    ESTABLISHMENT = 'ESTABLISHMENT',
    REPRESENTATIVE = 'REPRESENTATIVE',
    BANQUE = 'BANQUE',
    DRIVER = 'DRIVER',
    PICKUP = 'PICKUP_ADDRESS'
  }

  export enum MainBranch {
    TAD = 'TAD',
    CLIENT = 'CLIENT'
  }

  export enum PortalAssignment {
    TAD = 'TAD',
    CLIENT = 'CLIENT'
  }

  export enum UserStatus {
    INACTIF = 'INACTIF',
    ACTIF = 'ACTIF',
    DELETED = 'DELETED'
  }

  export interface Pageable<T> {
    content: T[];
    totalElements: number;
    totalPages: number;
    size: number;
    number: number;
    first: boolean;
    last: boolean;
    empty: boolean;
    sort: {
      empty: boolean;
      sorted: boolean;
      unsorted: boolean;
    };
    offset: number;
    pageNumber: number;
    pageSize: number;
    paged: boolean;
    unpaged: boolean;
    numberOfElements: number;
  }
  
  
  export type IClientPageable = Pageable<IClient>;
  export interface ClientPageFilterParams {
    page?: number;
    size?: number;
    sortBy?: string;
    sortDirection?: 'asc' | 'desc';
  }
  
  export interface IClientBasicInfo {
    id: number;
    firstname: string;
    lastname: string;
  }
  
export interface WorkStatusDTO {
    collaboratorId: number;
    status: StatusType;
    dateRangeOption: DateRangeOption;
    customStartDate?: string | null;
    customEndDate?: string | null;
}
export enum StatusType {
  IN_OFFICE = 'IN_OFFICE',
  WORK_FROM_HOME = 'WORK_FROM_HOME',
  WORK_OFFSITE = 'WORK_OFFSITE',
  OUT_OF_OFFICE = 'OUT_OF_OFFICE',
  DO_NOT_DISTURB = 'DO_NOT_DISTURB',
  ON_LEAVE = 'ON_LEAVE',
  SICK_LEAVE = 'SICK_LEAVE',
  FAMILY_TIME = 'FAMILY_TIME',
}

export enum DateRangeOption {
  TODAY = 'TODAY',
  TOMORROW = 'TOMORROW',
  THIS_WEEK = 'THIS_WEEK',
}

export interface IClientDropdownList {
  id: number;
  firstname: string;
  lastname: string;
  departmentId: string;
}