import { IconDefinition } from "@fortawesome/free-solid-svg-icons";
import { ReactNode } from "react";

export type TableColumn = {
  id: string;
  label: string;
  type?: string;
  align?: 'left' | 'center' | 'right';
  width?: number;
  options?: { value: string; label: string }[];
  isNotSortable?: boolean;
}
export interface TokenPayload {
  exp: number;
  iat: number;
  name: string;
  email: string;
  realm_access: {
    roles: string[];
  };
  isValid?: boolean;
  sub: string;
}

export interface FormFieldType<T> {
  name: keyof T;
  label: string;
  type: 'text' | 'date' | 'datetime' | 'number' | 'select' | 'color' | 'textarea' | 'checkbox' | 'multiple' | 'file' | 'time' | 'rating' | 'switch' | 'custom' | 'password' | 'combobox' | 'address' | 'checkbox-group' | 'combobox-multiple';
  placeholder?: string;
  required?: boolean | ((values: T) => boolean);
  icon?: string | IconDefinition;
  options?: { value: string; label: string | ReactNode }[];
  accept?: string;
  isDisabled?: (values: T) => boolean;
  disabled?: boolean,
  multiline?: boolean,
  rows?: number;
  showWhen?: (status: any) => boolean;
  showPassword?: boolean;
  getOptionLabel?: (option: any) => string;
  renderValue?: (selected: any) => string;
  onChange?: (selected: any, form: any) => void;
  onSearch?: (query?: string) => void;
  minLength?: number;
  maxLength?: number;
  hasAddInfrastructureModal?: boolean;
  hasAddEstablishmentModal?: boolean;
  hasAddContractModal?: boolean;
  hasAddClientModal?: boolean;
  onAddEstablishment?: () => void;
}

export interface TabItem {
  id: string;
  label: string;
  closable?: boolean;
  content?: any;
  mode?: string;
}

export enum TableType {
  Contrat = 'contrat',
  Circuit = 'circuit',
  Trajet = 'trajet',
  Chauffeur = 'chauffeur',
  Usager = 'usager',
  Avenant = 'avenant',
  AbsenceUsager = 'absence',
  DemandeAbsence = 'demande',
  Client = 'client',
  Etablissement = 'établissement',
  Vacance = 'vacance',
  Driver = 'chauffeur',
  AttendanceSheet = 'feuille de presence',
  SuiviTrajet = 'suivi trajet',
  Candidature = 'candidature',
  BesoinRecrutement = 'Besoin recrutement',
  SALARIE = 'salarié',
  Conge = 'congé',
  absence = 'absence',
  Formulaire = 'formulaire',
  Appointment = 'rendez-vous',
  DriverRoadmap = 'feuille de route',
  SubmittedRoadmap = 'feuille de route soumise',
  Document = 'Document',
  SuiviDocument = 'Demande',
  Demande = "demande",
  Secteur = 'secteur',
  Lot = 'lot',
  staff = 'staff',
  Agence = 'agence',
  Departement = 'departement',
  Vehicle = 'véhicule',
  Reparation = "réparation",
  VehicleIncident = "sinistre",
  Agent = 'agent',
  Role = 'role',
  Equipe = 'équipe',
  Module = 'module',
  Mileage = "kilométrage",
  Session = "session",
  Email = "email",
  Consumption = "consommation",
  Intervention = 'intervention',
  Affectation = "attribution / restitution",
  DocumentDemande = "demandeDocument",
  FuelFee = "frais carburant",
  IncidentType = "type de sinistre",
  VehicleBrandModel = "Marques et Modèles",
  VehicleType = "type de véhicule",
  TankerType = "Pétrolier",
  EmailTempalte = "email template",
  EmailHistory = "historique email",
  EmailAutomation = "automation email",
  GEOLOC = 'geoloc',
  Notification = "notification",
  FuelHistory = 'Carte Carburant',
  SuiviCartes = 'SuiviCartes',
  SupplierType = 'Fournisseur',
  ServiceProvider = 'Fournisseur',
  Export = 'export',
  Calendar = 'calendar',
  DocumentRequest = 'Document Request',
  Revision = 'révision',
  FuelType = 'Type de carburant',
  FuelSupplier = 'Pétrolier',
  VehicleRepair = 'Réparation'
}

export type ModeType = 'add' | 'edit' | 'view' | 'copy';

export enum TypeImport {
  CIRCUIT = "circuit",
  PASSENGER = "usager",
  VACANCE = "vacance",
  FUEL = "Fournisseur",
  GEOLOC = "geoloc",
  FuelFee = "Frais Carburant",
  ESTABLISHMENT = "établissement",
}


export type TimeUnit = "day" | "month" | "year";

export interface DrawerControlProps {
  openDrawer: {
    value: boolean
    onTrue: () => void
    onFalse: () => void
    onToggle: () => void
  }
}

export interface AddressData {
  address: string
  lat: number
  lng: number
  placeId?: string
  formattedAddress?: string
  city?: string
  postalCode?: string
  country?: string
}

export enum Civility {
  MR = 'MR',
  MME = 'MME',
  M_MME = 'M_MME',
  MM = 'MM',
  MMS = 'MMS',
  OTHER = 'OTHER'
}