

export enum DemandeStatus {
  EN_ATTENTE = "EN_ATTENTE",
  EN_TRAITEMENT = "EN_TRAITEMENT",
  VALIDEE = "VALIDEE",
  REFUSEE = "REFUSEE",
  EMPTY = ""
}
export enum TypeDemande {
  JUSTIFICATIF_PERSONNEL = "Justificatif personnel",
  DOCUMENT_OFFICIEL = "Document officiel",
  FICHIER_ADMINISTRATIF = "Fichier administratif",
  CONTRAT_TRAVAIL = "Contrat de travail",
  AUTRE = "Autre",
}

export enum PrioriteDemande {
  BASSE = "Basse",
  NORMALE = "Normale",
  HAUTE = "Haute",
  URGENTE = "Urgente",
}

export interface IDemande {
  id: string
  numeroDemande: string
  utilisateur: string
  typeDemande: TypeDemande
  intitule: string
  description: string
  dateCreation: string
  dateMiseAJour: string
  dateExpiration?: string
  status: DemandeStatus
  priorite: PrioriteDemande
  commentaire?: string
  documentAssocie?: string
  fichierAttache?: boolean,
  actif: boolean
}


