import { IBaseEntity } from "./client";
import { TableColumn } from "./common";

export enum DocumentType {
  ID_CARD = "ID_CARD",
  PASSPORT = "PASSPORT",
  DRIVER_LICENSE = "DRIVER_LICENSE",
  WORK_CERTIFICATE = "WORK_CERTIFICATE"
}
export enum RequestStatus {
  EN_ATTENTE = "PENDING",
  EN_TRAITEMENT = "PROCESSING",
  VALIDEE = "APPROVED",
  REFUSEE = "REJECTED",
  EMPTY = ""
}  
export enum PriorityLevel {
  BASSE = "LOW",
  NORMALE = "MEDIUM",
  HAUTE = "HIGH",
  URGENTE = "Urgent",
}         

export enum RequestType {
  PERSONAL_JUSTIFICATION = "PERSONAL_JUSTIFICATION",
  OFFICIAL_DOCUMENT = "OFFICIAL_DOCUMENT",
  ADMINISTRATIVE_FILE = "ADMINISTRATIVE_FILE",
  EMPLOYMENT_CONTRACT = "EMPLOYMENT_CONTRACT",
  OTHER = "OTHER",
}

export interface IDocumentRequest extends IBaseEntity {
  codeReq: string;
  userId: number;
  userUuid: number;
  userName : string,
  title : RequestType,
  type: DocumentType;
  statut: RequestStatus;
  active: boolean;
  submissionDate: string;     
  processingDate: string;     
  priority: PriorityLevel;
  observation: string;
  description: string;
  attachedFile?: boolean;
}

export interface AddDocumentRequestDTO {
  userId: number;
  userUuid: string | null;
  userName : string | null;
  title : RequestType,
  type: DocumentType;
  priority: PriorityLevel;
  observation?: string;
  description?: string;
}

export interface UpdateRequestDto {
  type: DocumentType;
  priority: PriorityLevel;
  status: RequestStatus,
  observation?: string;
  description?: string;
}

export const DEFAULT_DOCUMENT_REQUEST_TABLE_HEAD: TableColumn[] = [
  { id: "codeReq", label: "N° demande", type: "text" },
   { id: "title", label: "Intitulé", type: "text" },
  { id: "type", label: "Type", type: "text" },
  { id: "submissionDate", label: "Date Soumission", type: "date" },
  { id: "statut", label: "Statut", type: "text" },
  { id: "priority", label: "Priorité", type: "text" },
  { id: "action", label: "Action" },
]

export const DEFAULT_DOCUMENT_REQUEST_FILTERS: TableColumn[] = [
  { id: "codeReq", label: "N° demande", type: "text" },
  { id: "title", label: "Intitulé", type: "text" },
  { id: "type", label: "Type", type: "text" },
  { id: "priority", label: "Priorité", type: "text" },
  { id: "submissionDate", label: "Date Soumission", type: "date" },
  { id: "statut", label: "Statut", type: "text" },
  { id: "active", label: "Actif", type: "boolean" },
]

export const INITIAL_DOCUMENT_REQUEST_DATA: IDocumentRequest = {
  id: "",
  codeReq: "",
  userId: 0,
  userUuid: 0,
  userName : "",
  title : RequestType.ADMINISTRATIVE_FILE,
  type: DocumentType.DRIVER_LICENSE,
  statut: RequestStatus.EN_ATTENTE,
  active: true,
  submissionDate: "",
  processingDate: "",
  priority: PriorityLevel.NORMALE,
  observation: "",
  description: "",
  attachedFile: false,
}

export const DEFAULT_DOCUMENT_REQUEST_TABLE_HEAD_RH: TableColumn[] = [
  { id: "userName", label: "Nom", type: "text" },
   { id: "title", label: "Type", type: "text" },
  { id: "submissionDate", label: "Date Soumission", type: "date" },
  { id: "updatedAt", label: "Dernière modification", type: "date" },
  { id: "statut", label: "Statut", type: "text" },
  { id: "priority", label: "Priorité", type: "text" },
  { id: "action", label: "Action" },
]
