import { PrioriteDemande } from "./demande";

export interface NewFolderRequest {
  name: string;
  ownerId?: number;
  ownerUuid?: string | null;
  parentId?: number | null; // null if creating in root
}

export enum ContentTypeEnum {
  PDF = 'PDF',
  IMAGE = 'IMAGE',
  WORD = 'WORD',
  EXCEL = 'EXCEL'
}

export enum DocumentTypeEnum {
  WORK_CERTIFICATE = "WORK_CERTIFICATE",
  PRESENCE_CERTIFICATE = "PRESENCE_CERTIFICATE",
  ID_CARD = "ID_CARD",
  DRIVER_LICENCE = "DRIVER_LICENCE"
}

export interface AddDocumentRequest {
  name: string;
  documentType: string;
  ownerUuid?: string;
  ownerId?: number,
  folderId?: number | null;
}

export interface BulkDocumentRequest {
  documentIds: number[];
  ownerUuid: string;
}

export interface BulkMoveRequest {
  documentIds: number[];
  targetFolderId?: number; // Optional for move to root
  ownerUuid: string;
}
export interface FolderReference {
  id: number;
  name: string;
}


export interface FolderDTO {
  id: number;
  name: string;
  ownerId: number;
  ownerUuid : string;
  parent?: FolderDTO | null;
  favorite: boolean;
  context?: string; 
  sharedWith?: number[];
  documents?: DocumentDTO[];
  subFolders?: FolderDTO[];
}

export type FolderDetails = {
  id: number;
  name: string;
  sizeInBytes: number;
  documentCount: number;
  subfolderCount: number;
  createdDate: string;
};
interface IBaseEntity {
  id: number;
  createdAt?: string;
  updatedAt?: string;
}

export interface DocumentDTO extends IBaseEntity {
  name: string;
  path: string;
  size: number;
  contentType: ContentTypeEnum;
  s3Key: string;
  downloadUrl?: string;
  ownerId: number;
  ownerUuid: string;
  documentType: DocumentTypeEnum;
  customDocumentType?: string; 
  context?: string; 
  folder?: FolderReference | null;
  favorite: boolean;
}

export interface IDocument 
{ id: string;
  numeroDocument: string; 
  intitule: string; 
  importePar: string; 
  dateImportation: string; 
  dateFin: string; }

export type ISuiviDocument = {
  id: string;
  numeroSuivi: string;
  type: string;
  dateImportation: string;
  numeroDocument: string;
  observation: string;
};

export type DocumentStatus = 'traité' | 'non traité' | 'archivé' | 'en attente';
export type DocumentType = 'contrat' | 'attestation' | 'fiche de paie' | 'autre' | string;

export interface DocumentRequest {
  id:string;
  requestId:string;
  documentName:string;
  documentType:DocumentType;
  status:DocumentStatus;
  submissionDate:Date;
  processedDate?:Date;
  description?:string;
  attachment?:string[];
}

export interface DocumentCategory {
  id: string;
  name: string;
  description?: string;
  documents: DocumentRequest[];
}

interface DocumentFile {
  name: string;
  extension: string;
  size?: string;
  uploadDate?: string;
}

export interface Document {
  id: string;
  name: string;
  type: DocumentType;
  categoryId: string;
  uploadDate: Date;
  lastModified: Date;
  path: string;
  status: DocumentStatus;
  isArchived: boolean;
  metadata?: Record<string, any>;
  file?: DocumentFile;
  customType?: string;
  requester: {
    id: string;
    name: string;
    email?: string;
  };
  priority?: PrioriteDemande;
}

export interface DocumentFilter {
  search?: string;
  status?: DocumentStatus;
  dateRange?: {
    start: Date;
    end: Date;
  };
  documentType?: DocumentType;
  requesterId?: string;
  id: string
  numeroSuivi: string
  type: string
  dateImportation: string
  numeroDocument: string
  observation: string
}

// Define folder structure with documents
export interface Folder {
  id: string
  name: string
  files: number
  documents: IDocument[]
  subFolders: Folder[]
  parentId?: string
  favorited?: boolean
}

