import { DriverAbsenceStatus } from "./driver-absence"
import { IUser } from "./client";
import { AddressData } from "./common";
import { Dayjs } from "dayjs";

export enum RoadMapStatus {
  Valid = 'valide',
  NotValid = 'non_valide'
}
export enum SubmittedRoadMapStatus {
  Submitted = 'soumise',
  NotSubmitted = 'non_soumise',
}
export enum DriverRoadMapStatus {
  Disponible = 'disponible',
  Affecte = 'affecte',
  Absent = 'absent',
  Suspendu = 'suspendu',
  NonDisponible = 'non_disponible',
}

export interface IVehicle {
  id: number;
  vehiculeName: string;
  immatriculation: string;
  fuelCardNumber: string;
  fuelCardType: string;
}

export interface IDriverType extends IUser {
  driverStatus: DriverStatus;
  fuelCardNames: string[];
  departmentId: number;
  drivingLicenseName?: string;
  circuitNames: CircuiteInformations[];
  absenceNames: string[];
  sectorName?: string;
  agencyName?: string;
  departmentName?: string;
  vehicleName?: string;
  fuelVolume?: string;
  drivingLicenseExpirationDate?: string;
  documentPath?: string;
  residenceCardTitle?: string;
  residencePermitOrIDCard?: string;
  socialSecurityNumber?: string;
  entryDate?: string;
  fuelCardIds?: string[];
  circuitsId?: string[];
  mapAdresse?: AddressData;
  vehicle?: IVehicle;
  immatriculation?: string;
  fuelCardNumber?: string;
  fuelCardType?: string;
  colorCode?: string;
}

export interface IDriver {
  id: string
  firstName: string
  lastName: string
  vehicle: string
  fuelCard: string[]
  fuelVolume: string
  phone: string
  email: string
  departement: string
  status: DriverRoadMapStatus
  permis: string
  dateExpirationPermis: string
  titreCarteSejour: string
  cni: string
  civilite?: string
  dateOfBirth?: string
  address?: AddressData
  postalCode?: string
  city?: string
  startDate?: string
  circuit?: string
  registrationNumber?: string
  socialSecurityNumber?: string
  fuelType?: string[]
  isActive?: boolean
}

export interface CircuiteInformations {
  id: string;
  circuitCode: string;
  titled: string;
}
export enum DriverStatus {
  AVAILABLE = 'AVAILABLE',
  ABSENT = 'ABSENT',
}

export const DRIVER_STATUS = [
  { value: DriverStatus.AVAILABLE, label: 'Disponible' },
  { value: DriverStatus.ABSENT, label: 'Absent' },
];

export enum UserStatus {
  ACTIF = 'ACTIF',
  INACTIF = 'INACTIF',
}

export interface RoleDTO {
  id: number;
  name: string;
}

export type IPreparationDriver = {
  id: string
  nom: string
  prenom: string
  adresse: AddressData
  ville: string
  codePostal: string
  nomCircuit: string
  disponibilite?: string
  codeChauffeur?: string
  dateDepart?: string
  etat?: string
  observation?: string
  vehicle?: string
}

export type IRoadmap = {
id: string
nomChauffeur: string
date: string
nombreHeures: string
statut: RoadMapStatus
phone: string
email: string
};

export type IOldRoadmap = {
  id: string
  name: string
  driverName: string
  date: string
  nombreHeures: string
  };

export interface OldSubmittedRoadMapFilterParams {
    driverId: number;
    name?: string;
    driverName?: string;
    date?: string;    
    totalHours?: number;
    page?: number;
    size?: number;
    sortBy?: string;
    sortDirection?: 'asc' | 'desc';
 };

export type IValidRoadmap = {
  id: string
  date: string
  driverId : number 
  driverName: string
  totalJournee: number
  totalCentieme: number
  deduction: string
  paidHoursCentieme: number
  delta: string
  forfait: string
  nightHours: string
  waitingHours: string
  numberVacations: number
}
export type ValidRoadmapFilterParams = {
  date?: string
  driverName?: string
  page?: number;
  size?: number;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
}


export interface IAddRoadmap {
  id: string
  title: string
  nbrDriver: string
  sendDate: string
  sender :string
}
export interface ISubmittedRoadmap {
  id: string
  driverName: string
  departement: string
  status: string
  date: string
  nombreHeures: string
  phone : string
  email : string 
}

export enum AddressType {
  DRIVER = 'DRIVER',
}
export interface IActiveDriver {
  id: number;
  name: string;
  departmentId: number;
  departmentName: string;
}
export interface IActivePlanningDriver {
  id: number;
  name: string;
  departmentId: number;
  departmentName: string;
  planningDay : Dayjs;
}

export type DriverShortResponse = {
  id: string;
  firstName: string;
  lastName: string;
}