export interface IExport {
  id: string
  createdAt: string
  updatedAt: string
  exportFilesStatus: ExportFilesStatus
  startTime: string
  endTime: string
  user: string
  description: string
  filePath: string
  downloaded: boolean
  downloadDate: string
  classExported: string
  fileSize: number
}
export type SearchExportsParams = {
  id?: number;
  status?: ExportFilesStatus;
  startTime?: string;
  endTime?: string;
  user?: string;
  description?: string;
  filePath?: string;
  downloaded?: boolean;
  downloadDate?: string;
  classExported?: string;
  fileSize?: number;
  page?: number;
  size?: number;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
};

export enum ExportFilesStatus {
  FAILED = "FAILED",
  IN_PROGRESS = "IN_PROGRESS",
  DONE = "DONE"
}

export enum ExportTab {
  ALL = "ALL",
  COMPLETED = "COMPLETED",
  IN_PROGRESS = "IN_PROGRESS",
  FAILED = "FAILED"
}

export enum ExportModuleType {
  CONTRAT = 'Contrat',
  CIRCUIT = 'Circuit',
  TRAJET = 'Trajet',
  CHAUFFEUR = 'Chauffeur',
  USAGER = 'Usager',
  CLIENT = 'Client',
  ETABLISSEMENT = 'Établissement',
  VEHICULE = 'Véhicule',
  INCIDENT = 'Sinistre',
  CONSOMMATION = 'Consommation',
  INTERVENTION = 'Intervention',
  FRAIS_CARBURANT = 'Frais carburant',
  GEOLOC = 'Geoloc',
  NOTIFICATION = 'Notification',
  CARTE_CARBURANT = 'Carte Carburant'
}
