// src/shared/types/fleet-management/fuelSupplier.ts

import { FuelType } from '@/shared/types/fleet-management/fuelType';
import { IBaseEntity } from '../client';

export interface FuelSupplier extends IBaseEntity {
  supplierName: string;
  fuelType: FuelType;
  observation: string;
  active: boolean;
}

export interface FuelSupplierRequestDTO {
  id : string
  supplierName: string;
  fuelTypeId: string;
  observation: string;
  isActive: boolean;
}

export interface FuelSupplierDTO {
  id: number;
  supplierName: string;
  fuelType: FuelType;
  observation: string;
  isActive: boolean;
}
