export enum InterventionType {
    MAINTENANCE_AND_REVISION = 'MAINTENANCE_AND_REVISION',
    REPAIR = 'REPAIR',
    OTHER = 'OTHER'
}

export const InterventionTypeLabels = {
    [InterventionType.MAINTENANCE_AND_REVISION]: 'Maintenance et révision',
    [InterventionType.REPAIR]: 'Réparation',
    [InterventionType.OTHER]: 'Autre'
};

export const InterventionTypeOptions = [
    { value: InterventionType.MAINTENANCE_AND_REVISION, label: InterventionTypeLabels[InterventionType.MAINTENANCE_AND_REVISION] },
    { value: InterventionType.REPAIR, label: InterventionTypeLabels[InterventionType.REPAIR] },
    { value: InterventionType.OTHER, label: InterventionTypeLabels[InterventionType.OTHER] }
];

export type Intervention = {
    id: string;
    name: string;
    interventionType: InterventionType;
    customInterventionType?: string;
};

export type InterventionPageFilterParams = {
    id?: string;
    name?: string;
    interventionType?: InterventionType;
    page?: number;
    size?: number;
    orderBy?: string;
    orderDir?: 'asc' | 'desc';
};


//****** Service Provider ********* */

export enum CoverageZone {
    NATIONAL = 'NATIONAL',
    LOCAL = 'LOCAL',
}

export const CoverageZoneLabels = {
    [CoverageZone.NATIONAL]: 'National',
    [CoverageZone.LOCAL]: 'Local',
};

export const CoverageZoneOptions = [
    { value: CoverageZone.NATIONAL, label: CoverageZoneLabels[CoverageZone.NATIONAL] },
    { value: CoverageZone.LOCAL, label: CoverageZoneLabels[CoverageZone.LOCAL] },
];

export type ServiceProvider = {
    id: string;
    name: string;
    coverageZone: CoverageZone;
    intervention: Intervention;
    amount: number;
    active: boolean;
};

export type ServiceProviderRequest = {
    id: string;
    name: string;
    coverageZone: CoverageZone;
    interventionId: string;
    interventionType: InterventionType;
    amount: number;
};

export type ServiceProviderPageFilterParams = {
    id?: string;
    name?: string;
    coverageZone?: CoverageZone;
    interventionName?: string;
    page?: number;
    size?: number;
    orderBy?: string;
    orderDir?: 'asc' | 'desc';
};

export function mapServiceProviderToRequest(serviceProvider: ServiceProvider): ServiceProviderRequest {
    return {
        id: serviceProvider.id,
        name: serviceProvider.name,
        coverageZone: serviceProvider.coverageZone,
        interventionId: serviceProvider.intervention.id,
        interventionType: serviceProvider.intervention.interventionType,
        amount: serviceProvider.amount,
    };
}