import { VehicleType } from "./vehicleType";

export type VehicleBrandModel = {
    id: string;
    brandName: string;
    modelName: string;
    generalMaintenanceDate?: string;
    observation?: string;
    vehicleType: VehicleType;
    active: boolean;
};

export type VehicleBrandModelRequest = {
    id: string;
    brandName: string;
    modelName: string;
    generalMaintenanceDate?: string;
    observation?: string;
    vehicleType: string;
    active: boolean;
};

export interface VehicleBrandModelPageFilterParams {
    id?: string;
    brandName?: string;
    modelName?: string;
    vehicleTypeName?: string;
    page?: number;
    size?: number;
    orderBy?: string;
    orderDir?: 'asc' | 'desc';
}

export const mapVehicleBrandModelToRequest = (
    vehicleBrandModel: VehicleBrandModel): VehicleBrandModelRequest => {
    const vehicleTypeId = vehicleBrandModel.vehicleType.id;

    return {
        id: vehicleBrandModel.id,
        brandName: vehicleBrandModel.brandName,
        modelName: vehicleBrandModel.modelName,
        generalMaintenanceDate: vehicleBrandModel.generalMaintenanceDate,
        observation: vehicleBrandModel.observation,
        vehicleType: vehicleTypeId,
        active: vehicleBrandModel.active,
    };
};