export interface VehicleRepair {
  id: string
  vehicleId: string
  licensePlate: string
  repairDate: string
  mileage: number
  repairStatus: RepairStatus
  serviceType: ServiceType
  garageName: string
  departmentId: string
  departmentName : string
  parts: string
  quantity: number
  quoteAmount: number
  costHT: number
  costTTC: number
  accepted: boolean
  invoiceNumber: string
  invoiceDate: string
  immobilizationStart: string
  immobilizationEnd: string
  observation: string
  serviceProviderId: string
  serviceProviderName: string
  interventionId: string
  interventionName: string
  sectorName : string
  active: boolean
}

export enum RepairStatus {
  PENDING = "PENDING",
  IN_PROGRESS = "IN_PROGRESS",
  CLOSED = "CLOSED",
}

export enum ServiceType {
  MAINTENANCE_AND_REVISION = "MAINTENANCE_AND_REVISION",
  REPAIR = "REPAIR",
  OTHER = "OTHER",
}

export const RepairStatusOptions = [
  { value: RepairStatus.PENDING, label: "En attente" },
  { value: RepairStatus.IN_PROGRESS, label: "En cours" },
  { value: RepairStatus.CLOSED, label: "Fermé" },
]

export const ServiceTypeOptions = [
  { value: ServiceType.MAINTENANCE_AND_REVISION, label: "Révision et entretien" },
  { value: ServiceType.REPAIR, label: "Réparation" },
  { value: ServiceType.OTHER, label: "Autre" },
]

export interface VehicleRepairListResponse {
  id: string
  vehicleId: string
  vehicleName: string
  licensePlate: string
  repairDate: string
  mileage: number
  repairStatus: RepairStatus
  serviceType: ServiceType
  garageName: string
  departmentId: string
  parts: string
  quantity: number
  quoteAmount: number
  costHT: number
  costTTC: number
  accepted: boolean
  invoiceNumber: string
  invoiceDate: string
  immobilizationStart: string
  immobilizationEnd: string
  observation: string
  serviceProviderId: string
  serviceProviderName: string
  interventionId: string
  interventionName: string
  active: boolean
}

export interface VehicleRepairRequest {
  id : string,  
  vehicleId: string
  departmentId : string
  licensePlate: string
  repairDate: string
  mileage: number
  garageName: string
  parts: string
  quantity: number
  quoteAmount: number
  costTTC : number
  observation: string
  serviceProviderId: string
  interventionId: string
  sectorName: string | undefined
  active: boolean
}

export interface VehicleRepairPageFilterParams {
  page: number
  size: number
  orderBy: string
  orderDir: "asc" | "desc"
  id?: number
  vehicleId?: string
  licensePlate?: string
  repairStatus?: RepairStatus
  serviceType?: ServiceType
  garageName?: string
  repairDate?: string
}

export const getRepairStatusColor = (status: RepairStatus): string => {
  switch (status) {
    case RepairStatus.PENDING:
      return "#FFA500"
    case RepairStatus.IN_PROGRESS:
      return "#2196F3"
    case RepairStatus.CLOSED:
      return "#4CAF50"
    default:
      return "#9E9E9E"
  }
}

export const mapVehicleRepairToRequest = (repair: VehicleRepair): VehicleRepairRequest => {
  return {
    id : repair.id,
    vehicleId: repair.vehicleId,
    departmentId : repair.departmentId,
    licensePlate: repair.licensePlate,
    repairDate: repair.repairDate,
    mileage: repair.mileage,
    garageName: repair.garageName,
    parts: repair.parts,
    quantity: repair.quantity,
    quoteAmount: repair.quoteAmount,
    costTTC : repair.costTTC,
    observation: repair.observation,
    serviceProviderId: repair.serviceProviderId,
    interventionId: repair.interventionId,
    sectorName : repair.sectorName,
    active: repair.active,
  }
}
