export interface FuelAnomalyConfig {
  vehicleStopVerification: boolean;
  stopDetectionDelay: string;
  multipleUsePerDay: boolean;
  fuelOutsideServiceArea: boolean;
  fuelOutsideServiceHours: boolean;
  abnormallyHighVolume: boolean;
  cardUsedDuringStop: boolean;
  useWithoutPlannedTrip: boolean;
  repeatedStationShortInterval: boolean;
  abnormalConsumption: boolean;
  useOutsideTrip: boolean;
}
export interface MileageAnomalyConfig {
  abnormalConsumptionDeviation: boolean;
  averageConsumptionPerKm: boolean;
}

export const MILEAGE_ANOMALY_INITIAL_DATA: MileageAnomalyConfig = {
  abnormalConsumptionDeviation: false,
  averageConsumptionPerKm: false,
};

export const FUEL_ANOMALY_INITIAL_DATA: FuelAnomalyConfig = {
  vehicleStopVerification: false,
  stopDetectionDelay: '24',
  multipleUsePerDay: false,
  fuelOutsideServiceArea: false,
  fuelOutsideServiceHours: false,
  abnormallyHighVolume: false,
  cardUsedDuringStop: false,
  useWithoutPlannedTrip: false,
  repeatedStationShortInterval: false,
  abnormalConsumption: false,
  useOutsideTrip: false,
};

export interface IVehicleList {
  id: string;
  firstName: string;
  lastName: string;
  vehicle: string;
  FuelCardNumber: string;
  phone: string;
  email: string;
  departmentName: string;
}
