import { InterventionType } from "./vehicule";

export interface IIncident {
  id: string;
  department: string;
  date: string;
  vehicle: string;
  driver: string;
  damages?: string;
  circumstances?: string;
  responsibility?: string;
  declaration?: TypeDeclaration;
  intervention?: string;
  interventionType?: InterventionType;
  supplier?: string;
  amount?: number;
  status: IncidentStatus;
  isActive: boolean;
}
export enum TypeDeclaration {
  Axa = 'axa',
  Adanev = 'adanev',
}
export enum IncidentStatus {
  InProgress = 'en_cours',
  Resolved = 'resolu',
  WaitingForParts = 'en_attente',
  Repair = 'reparation',
}