import { InterventionType } from "./vehicule";

export interface IRevision {
  id: string;
  immatriculation: string;
  type: UserType;
  personne: string;
  dateRevision: string;
  garageRevision: string;
  adresse: string;
  supplier: string;
  typeIntervention: InterventionType;
  intervention: string;
  statutCT: StatutCT;
  kilometrage: string;
  observation: string;
  dateCT: string;
  copieCT?: string; // URL du fichier PDF/Image
  idfFlotteVehicule: string;
  derniereMiseAJour: string;
  isActive: boolean;
}

// History tracking interface
export interface IRevisionHistory {
  id: string;
  revisionId: string;
  action: RevisionAction;
  actionBy: string;
  actionDate: string;
  previousStatus?: StatutCT;
  newStatus?: StatutCT;
  comment?: string;
  changes?: RevisionChanges;
}

export interface RevisionChanges {
  field: string;
  oldValue: any;
  newValue: any;
}

export enum RevisionAction {
  CREATED = 'CREATED',
  UPDATED = 'UPDATED',
  STATUS_CHANGED = 'STATUS_CHANGED',
  ARCHIVED = 'ARCHIVED',
  RESTORED = 'RESTORED',
  CT_DOCUMENT_UPLOADED = 'CT_DOCUMENT_UPLOADED',
  CT_DOCUMENT_REMOVED = 'CT_DOCUMENT_REMOVED',
}

export enum UserType {
  CHAUFFEUR = 'Chauffeur',
  SEDENTAIRE = 'Sédentaire',
}

export enum StatutCT {
  A_FAIRE = 'À faire',
  EN_COURS = 'En cours',
  TERMINE = 'Terminé',
}

export enum RevisionTab {
  A_FAIRE = 'a_faire',
  TERMINE = 'termine',
}

export interface IRevisionFilters {
  statutCT?: StatutCT;
  garageRevision?: string;
  personne?: string;
  dateRevisionDebut?: string;
  dateRevisionFin?: string;
  kilometrageMin?: number;
  kilometrageMax?: number;
  type?: UserType;
  isActive?: boolean; // For filtering archived/active items
} 