export interface ISuiviCarte {
  id: string;
  numeroCarteCarburant: string;
  nomConducteur: string;
  dateTransaction: string;
  petrolier: string;
  typeCarburant: string;
  montantTransaction: number;
  quantite: number;
  adresseTransaction: string;
  isActive: boolean;
}
export interface IFuelCardImportHistory {
id: string;
fileName: string;
importStartDate: string;
importEndDate: string;
status: string;
type: string;
}
export const INITIAL_SUIVI_CARTE_DATA: ISuiviCarte = {
  id: "",
  numeroCarteCarburant: "",
  nomConducteur: "",
  dateTransaction: "",
  petrolier: "",
  typeCarburant: "",
  montantTransaction: 0,
  quantite: 0,
  adresseTransaction: "",
  isActive: true,
};

export interface ISuiviCarteImport {
  id: string;
  petrolier: string;
  fichierPetrolier: File | null;
}

export const INITIAL_SUIVI_CARTE_IMPORT_DATA: ISuiviCarteImport = {
  id: "",
  petrolier: "",
  fichierPetrolier: null,
};

export enum TypeCarburant {
  Diesel = "Diesel",
  Essence = "Essence",
  Electrique = "Électrique",
  Hybride = "Hybride"
}

export enum PetrolierType {
  DKV = "DKV",
  TOTAL = "TOTAL",
  SHELL = "SHELL",
  BP = "BP",
  ESSO = "ESSO"
} 