export interface IVehicle {
    id: string;
    marque: string;
    modele: string;
    numeroImmatriculation: string;
    chauffeur: string;
    typeVehicule: string;
    department: string;
    nombrePlaces?: string;
    statut: string
    placesFauteuilRoulant?: string;
    dateImmatriculation?: string;
    geolocationCode?: string;
    carteGrise?: string;
    fuelType?: string;
    providerType?: ISupplierType;
    isActive: boolean;
    contratId?: string;
    observation?: string;
    // Informations de location
    dateCommande?: string;
    dateLivraison?: string;
    dureeLocation?: number;
    proprietaire?: string;
    tarifLocation?: number;
    secteur?: string;
    license?: string;
  }

  export enum VehicleStatut {
    EnCours = 'reparation_en_cours',
    Affecte = "affecte",
    NonAffecte = "non_affecte",
  }
  
  export interface IVehicleModel {
    id: string
    marque: string
    modele: string
    dateEntretien?: string
    typeVehicule?: string
    observation?: string
    isActive: boolean
  }
  
  export interface IVehicleType {
    id: string
    intitule: string
    observation?: string
    isActive: boolean
  }

  export interface ISupplierType {
    id: string;
    nomFournisseur: string;
    zoneCouverture: ZoneCouvertureType;
    typeIntervention: string;
    intervention: string;
    prix: number;
    isActive: boolean;
  }
  export enum ZoneCouvertureType {
    National = 'national',
    Local = 'local',
  }
  
  export interface ISupplierIntervention {
    id: string;
    nomIntervention: string;
    typeIntervention: InterventionType;
    autreTypeIntervention?: string;
  }
  
  export enum InterventionType   {
    Entretien = 'révision et entretien',
    Réparation = 'réparation',
    Autre = 'autre',
  }
  