import { AddressType, IBaseEntity, IUser } from './client';
import { Address } from './establishment';
import { Civility } from './common';
import {
  IdWithTransportScheduleAmendmentsDTO,
  PeriodOfDay,
  ScheduleAmendmentDTO,
} from './ammendment-passenger';

export enum RoleStatus {
  ENABLED = 'ENABLED',
  DISABLED = 'DISABLED',
}

export enum CustodyCategory {
  ALTERNATING_CUSTODY = 'ALTERNATING_CUSTODY',
  RETURNS_AT_NOON = 'RETURNS_AT_NOON',
}

export enum ParticularityTransport {
  AUTISME = 'AUTISM',
  DEFICIENT_VISUEL = 'VISUAL_IMPAIRMENT',
  FAUTEUIL_ELECTRIQUE = 'POWER_WHEELCHAIR',
  FAUTEUIL_ELECTRIQUE_103 = 'POWER_WHEELCHAIR_103',
  FAUTEUIL_MANUEL = 'MANUAL_WHEELCHAIR',
  FAUTEUIL_MANUEL_TRANSFERABLE = 'MANUAL_WHEELCHAIR_TRANSFERABLE',
  FAUTEUIL_PLIANT = 'FOLDING_WHEELCHAIR',
  GILLES_DE_LA_TOURETTE = 'TOURETTE_SYNDROME',
  MALVOYANT = 'PARTIALLY_SIGHTED',
  MARCHANT = 'WALKING',
  MOBILITE_REDUITE = 'REDUCED_MOBILITY',
  NON_TRANSFERABLE = 'NON_TRANSFERABLE',
  PERSONNE_AGEE = 'ELDERLY_PERSON',
  TRANSFERABLE = 'TRANSFERABLE',
  TRANSPORT_INDIVIDUALISE = 'INDIVIDUALIZED_TRANSPORT',
  TRISOMIE_21 = 'DOWN_SYNDROME',
}

export enum State {
  CONTROLLED = 'CONTROLLED',
  UNCONTROLLED = 'UNCONTROLLED',
}
export const _PassengerStatus = [
  { value: State.CONTROLLED, label: 'Contrôlé' },
  { value: State.UNCONTROLLED, label: 'Non Contrôlé' },
];

export enum SchoolClass {
  SECONDE = 'SECONDE',
  TERMINALE = 'TERMINALE',
  CE1 = 'CE1',
  CE2 = 'CE2',
  CM1 = 'CM1',
  CM2 = 'CM2',
}

export enum RelationType {
  MOTHER = 'MOTHER',
  FATHER = 'FATHER',
  GRANDPARENT = 'GRANDPARENT',
  GROUP_HOME = 'GROUP_HOME',
  MEDICAL_FACILITY = 'MEDICAL_FACILITY',
  OTHER = 'OTHER',
  PARENT = 'PARENT',
}

export enum PassengerCivility {
  MR = 'MR',
  MME = 'MME',
}

export interface PassengerContact extends IBaseEntity {
  landlinePhoneNumbers: string[];
  mobilePhoneNumbers: string[];
  assignedPersonNames: string[];
}

export interface AddressDTO extends IBaseEntity {
  latitude: number;
  longitude: number;
  street: string;
  city: string;
  country: string;
  zipCode: string;
  additionalAddress: string;
  addressType: AddressType;
}

export interface PassengerRepresentative extends IBaseEntity {
  firstName: string;
  lastName: string;
  email?: string;
  civility: Civility;
  type: RelationType | null;
}

export interface Representative extends PassengerRepresentative {
  parentalAuthorization: boolean;
  arrivalNotification: boolean;
  circuitId: string;
  circuitCode: string;
  contacts: PassengerContact[];
  addresses: Address[];
  addressDetails?: string;
  transportSchedulesRepresentative: TransportSchedule[];
}

export interface Interlocutor extends PassengerRepresentative {
  mobilePhone: string;
  observations: string;
}

export interface IRole extends IBaseEntity {
  name: string;
  description: string;
  status: RoleStatus;
  permissions: string[];
}

export interface IUserPassenger
  extends Omit<IUser, 'addresses' | 'password' | 'roles' | 'civility' | 'isArchived'> {
  roles: IRole[];
  civility?: PassengerCivility;
}

export interface IPassengerList extends IUserPassenger {
  openingDays: string;
  observations: string;
  startTransport: string;
  lastAmendmentDate: string;
  specificity: string;
  referentTeacherName: string;
  custodyCategory: CustodyCategory;
  particularityTransport: ParticularityTransport | null;
  state: State;
  establishmentTransportSchedules: EstablishmentTransportScheduleDTO[];
  idDepartment: number;
  departmentName: string;
  age: number;
  schoolClass: SchoolClass | null;
  representatives: Representative[];
  interlocutor: Interlocutor | null;
  archived: boolean;
}

export interface EstablishmentTransportScheduleDTO extends IBaseEntity {
  idEstablishment: number;
  establishmentName: string;
  weekType: WeekType;
  dayScheduleEstablishments: DayScheduleEstablishmentDTO[];
}

export interface DayScheduleEstablishmentDTO extends IBaseEntity {
  dayOfWeek: DaysOfWeek;
  periodOfDay: PeriodOfDay;
}

export interface SearchPassengerParams {
  id?: number;
  lastName?: string;
  firstName?: string;
  birthDate?: string;
  birthPlace?: string;
  schoolClass?: string;
  startTransport?: string;
  lastAmendmentDate?: string;
  observations?: string;
  departmentName?: string;
  type?: string;
  representativeFirstName?: string;
  representativeLastName?: string;
  representativeEmail?: string;
  landlinePhoneNumbers?: string;
  mobilePhoneNumbers?: string;
  address?: string;
  circuitCode?: string;
  establishmentName?: string;
  page?: number;
  size?: number;
  sortBy?: string;
  sortDir?: 'asc' | 'desc';
}

export interface TransportSchedule extends IBaseEntity {
  weekType: WeekType;
  dayScheduleRepresentative: DaySchedule[];
}
export interface DaySchedule extends IBaseEntity {
  dayOfWeek: DaysOfWeek;
  sens: SensTrip;
  checked: boolean;
}
export enum WeekType {
  EVEN = 'EVEN',
  ODD = 'ODD',
}
export enum DaysOfWeek {
  MONDAY = 'MONDAY',
  TUESDAY = 'TUESDAY',
  WEDNESDAY = 'WEDNESDAY',
  THURSDAY = 'THURSDAY',
  FRIDAY = 'FRIDAY',
  SATURDAY = 'SATURDAY',
  SUNDAY = 'SUNDAY',
}
export enum SensTrip {
  DEPARTURE = 'DEPARTURE',
  RETURN = 'RETURN',
}

export interface PassengerNameDTO {
  id: number;
  firstName: string;
  lastName: string;
  departmentId: number;
}
export interface PassengerNameDTO {
  id: number;
  firstName: string;
  lastName: string;
  departmentId: number;
}
