import { Dayjs } from 'dayjs';
import { TableColumn } from './common';
import { IActiveDriver } from './driver';

export interface RoadMapPageFilterParams {
  status: string;
  page?: number;
  size?: number;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
}
export type IRoadmap = {
  id: string;
  name: string;
  driverName: string;
  driverId: string;
  date: string;
  departementName: string;
  nombreHeures: string;
  status: RoadMapStatus;
  phone: string;
  email: string;
};
export enum RoadMapStatus {
  Valid = 'VALIDE',
  NotValid = 'NON_VALIDE',
  InProgress = 'IN_PROGRESS',
}
export const INITIAL_DRIVER_ROADMAP_DATA: IRoadmap = {
  id: '',
  name: '',
  driverName: '',
  driverId: '',
  date: '',
  departementName: '',
  nombreHeures: '',
  status: RoadMapStatus.NotValid,
  phone: '',
  email: '',
};
export const DEFAULT_DRIVER_ROADMAP_TABLE_HEAD: TableColumn[] = [
  { id: 'driverName', label: 'Nom du chauffeur', type: 'text', align: 'left' },
  { id: 'date', label: 'Date', type: 'dateRoadMap', align: 'left' },
  { id: 'departementName', label: 'Département', type: 'text', align: 'left' },
  { id: 'status', label: 'Status', type: '', align: 'left' },
  { id: 'totalDay', label: "Nombre d'heures", type: 'text', align: 'center', width: 150 },
  { id: 'contacter', label: 'Contacter', type: 'action', align: 'center' },
  { id: 'anciennesListes', label: 'Anciennes listes', type: 'action', align: 'center' },
];

export const ROADMAP_STATUS_OPTIONS = [
  { value: 'VALIDE', label: 'Traitée' },
  { value: 'NON_VALIDE', label: 'Non traitée' },
  { value: 'IN_PROGRESS', label: 'En cours' },
];

export interface SubmittedRoadMapDTO {
  id: string;
  isSubmitted: boolean;
  driverId: number;
  driverName: string;
  departementId: number;
  departementName: string;
  email : string;
  phone:string;
  date:string;
  workedDaysDates?: string[];
  createdByCron: boolean;
}

export interface SubmittedRoadMapFilterParams {
  driverName?: string;
  departementName?: string;
  isSubmitted?: boolean;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
  page?: number;
  size?: number;
}

export const INITIAL_SUBMITTED_ROADMAP_DATA: SubmittedRoadMapDTO = {
  id: '',
  isSubmitted: false,
  driverId: 0,
  driverName: '',
  departementId: 0,
  departementName: '',
  email: '',
  phone: '',
  date: '',
  createdByCron: true,
  };

export interface DriverRoadMapDetailsDTO {
  id: number;
  name: string;
  firstName: string;
  lastName: string;
  cardNumber: string;
  immatriculation: string;
  licenceNumber: string;
  date: string;
  driverName: string;
  driverId: number;
  departementName: string;
  departementAddress: string;
  departementId: number;
  workedDays: WorkedDayDTO[];
}

  export interface DriverRoadMapDetailsDTO {
    id: number;
    name: string;
    firstName: string;
    lastName: string;
    cardNumber: string;
    immatriculation: string;
    licenceNumber: string;
    date: string;
    driverName: string;
    driverId: number;
    departementName: string;
    departementAddress: string;
    departementId: number;
    workedDays: WorkedDayDTO[];
  }
  
  export interface WorkedDayDTO {
    driverRoadMapId: number;
    date: string;
    fuelAmount: number;
    observation: string;
    mileageIntervall: {
      startMileage: number;
      endMileage: number;
    } | null;
    roads: {
      type: string;
      startHour: string;
      endHour: string;
    }[];
    otherTrips: {
      type: string;
      startHour: string;
      endHour: string;
    }[];
  }

  export interface MileageIntervalDTO {
    startMileage: number;
    endMileage: number;
  }
  
  export interface RoadDTO {
    startHour: string;
    endHour: string;
    type: string;
  }
  
  export interface OtherTripDTO {
    startHour: string;
    endHour: string;
    type: string;
  }
  export interface OldRoadMapByDriverFilterParams {
    driverId?: number;
    name?: string;
    date?: string;
    page?: number;
    size?: number;
    sortBy?: string;
    sortDirection?: 'asc' | 'desc';
  }
export interface IRoadMapStatistics {  
  activeDrivers: number;
  submittedRoadmaps: number;
  notValidatedRoadmaps: number;
  notSubmittedRoadmaps: number;
  }
export interface WorkedDayDTO {
  driverRoadMapId: number;
  date: string;
  fuelAmount: number;
  observation: string;
  mileageIntervall: {
    startMileage: number;
    endMileage: number;
  } | null;
  roads: {
    type: string;
    startHour: string;
    endHour: string;
  }[];
  otherTrips: {
    type: string;
    startHour: string;
    endHour: string;
  }[];
}
export enum PeriodType {
  Matin = 'MATIN',
  Midi = 'MIDI',
  ApresMidi = 'APRES_MIDI',
  Soir = 'SOIR',
}
export type ValidatedRouteSheetRoute = {
  id: number;
  type: PeriodType;
  startHour: Date;
  endHour: Date;
};
export type ITotalHourResult = {
  id: string;
  totalDay: string;
  totalCentieme: string;
  deduction: string;
  paidHoursCentieme: string;
  delta: string;
  forfait: string;
  nightHours: string;
  waitingHours: string;
  numberVacations: string;
};
export type ValidatedRouteSheetDay = {
  id: number;
  date: Date;
  validatedRoads: ValidatedRouteSheetRoute[];
  totalRoadMapDaily: ITotalHourResult;
};

export type ValidatedRoadMapTable = {
  id: number;
  date: Date;
  dailyRoadMaps: ValidatedRouteSheetDay[];
  totalRoadMapMonthlyDTO: ITotalHourResult;
};

export type ICombinedTable = {
  id: number;
  combinedTableDayList: CombinedTableDay[];
};

export type CombinedTableDay = {
  id: number;
  date: string;
  isChecked:boolean;
  roads: RoadPeriod[];
};

export type RoadPeriod = {
  startHour: string;
  endHour: string;
  type: PeriodType;
};

export type IDriverRoadmap = {
  id: number;
  workedDays: WorkedDay[];
};

export type WorkedDay = {
  driverRoadMapId: number;
  date: string | null;
  fuelAmount: number;
  observation: string;
  mileageIntervall: MileageIntervall;
  roads: RoadSegment[];
  otherTrips: OtherTrip[];
};

export type MileageIntervall = {
  startMileage: number;
  endMileage: number;
};

export type RoadSegment = {
  startHour: string;
  endHour: string;
  type: PeriodType;
};

export type OtherTrip = {
  type: 'GARAGE_VISIT' | 'MEDICAL_VISIT';
  startHour: string;
  endHour: string;
};

export type IGeolocationRoute = {
  duration: number;
  distance: number;
  startHour: string;
  endHour: string;
  avgSpeed: number;
  departureAddress: string;
  arrivalAddress: string;
};

export type IGeolocationDay = {
  date: string;
  routes: IGeolocationRoute[];
};

export type IGeolocationData = {
  carRegistration: string;
  date: string;
  days: IGeolocationDay[];
};

export interface PlanningData {
  date: string;
  dailyPlannings: DailyPlanning[];
}

export interface DailyPlanning {
  date: string;
  tripPlannings: TripPlanning[];
}

export interface TripPlanning {
  startHour: string;
  endHour: string;
  nbPassengers: number;
  departure: string;
  destination: string;
}

export interface SendRoadMapPlanningFormValues {
  sendDate: Dayjs | Date | null;
  startDate: Dayjs | Date | null;
  endDate: Dayjs | Date | null;
  sendHour: Dayjs | Date | null;
  planningDayOption: 'same' | 'next' | 'specific';
  planningDate: Dayjs | Date | null;
  dayOfWeek: string;
  mode: 'journee' | 'quotidienne' | 'hebdomadaire';
  selectedDrivers: IActiveDriver[];
  title: string;
}
export type SchedulePlanningPayload = {
  type: string;
  title: string;
  sendDate: string | null;
  sendTime: string | null;
  planningDayOption: 'specific' | 'same' | 'next';
  planningDate: string | null;
  driverIds: number[];
  startDate: string | null;
  endDate: string | null;
  dayOfWeek: string | null;
};

export interface PlanningRequestFilterParams {
  id?: string;
  title?: string;
  description?: string;
  sendDate?: string;  
  driversCount?: number;
  planningType?: string;
  page: number;
  size: number;
  sortBy: string;
  sortDirection: 'asc' | 'desc';
}

export interface PlanningRequest {
  id: string;
  title: string;
  agentName?: string;
  sendDate?: string;  
  driversCount?: number;
  planningType?: string;
  startDate?: string;
  endDate?: string;
  createdAt?: string;
}
export interface PlanningRequestDetails {
  id: string;
  driverName: string;
  sendDate: string;  
  sendHour: string;
  trips?: TripDetails[];

  distinctNames?: string[];
  circuitsCodes?: string[];
}
 interface Address {
  street: string;
  city: string;
  postalCode: string;
  country: string;
}
export interface TripDetails {
  codeCircuit: string;
  departure: Address;
  destination: Address;
  nbPassengers: number;
  vehicleId: string;
  startHeure: string;
  startMinute: string;
  endHeure: string;
  endMinute: string;
  date: string;
  pickupStartHeure: string;
  pickupStartMinute: string;
  returnEndHeure: string;
  returnEndMinute: string;
}
export type ValidatedRoadMapArgs = {
  id?: string ;
  date?: string;
  driverId?: string;
};