import { RoleStatus } from "../api/stores/roleStore";

export interface IRole {
  id: string;
  name: string;
  description: string;
  createdAt?: string;
  status: RoleStatus;
  modules: RoleModule[];
  permissions?: string[];
}

export interface RolePageFilterParams {
  page?: number;
  size?: number;
  sortBy?: string;
  sortDirection?: 'ASC' | 'DESC';
}

export interface RoleModule {
  date: string;
  module: string;
  permissions: string[];
}

export interface RolePayload {
  id: string;
  name: string;
  description: string;
  createdAt: string;
  status: RoleStatus;
  modules: RoleModule[];
}
