
export interface IWorkingHours {
  id: string;
  dayOfWeek: number; 
  startHour: number; 
  endHour: number;   
  employeeId: string;
  employeeName?: string;
  createdDate: string;
  lastModifiedDate: string;
}


export interface CreateWorkingHoursRequest {
  dayOfWeek: number;
  startHour: number;
  endHour: number;
  employeeId: string;
}


export interface UpdateWorkingHoursRequest {
  dayOfWeek?: number;
  startHour?: number;
  endHour?: number;
}


export interface WorkingHoursSlot {
  dayOfWeek: number;
  startHour: number;
  endHour: number;
  id?: string; 
}


export const DAY_NAMES = {
  1: 'Lundi',
  2: 'Mardi', 
  3: 'Mercredi',
  4: 'Jeudi',
  5: 'Vendredi',
  6: 'Samedi',
  7: 'Dimanche'
} as const;

export const TIME_SLOTS = Array.from({ length: 11 }, (_, i) => i + 8); // [8, 9, 10, ..., 18]


export const formatTime = (hour: number): string => {
  return `${hour.toString().padStart(2, '0')}:00`;
};


export const getDayName = (dayOfWeek: number): string => {
  return DAY_NAMES[dayOfWeek as keyof typeof DAY_NAMES] || `Jour ${dayOfWeek}`;
};

