import Box from '@mui/material/Box';

import { useBoolean } from '@/hooks';
import { useResponsive } from '@/hooks';

import Main from './main';
import Header from './header';
import NavMini from './nav-mini';
import NavVertical from './nav-vertical';
import { useNavBar } from '@/contexts/settings/nav-bar-context';
import { useTheme, alpha } from '@mui/material/styles';
import { useEffect } from 'react';

// ----------------------------------------------------------------------

type Props = {
  children: React.ReactNode;
};

export default function DashboardLayout({ children }: Props) {
  const theme = useTheme();

  const nav = useBoolean();
  const { isNavBarMinimized, toggleNavBar } = useNavBar();
  const renderNavMini = <NavMini />;
  const isSmallScreen = useResponsive('down', 'lg');
  
  const renderNavVertical = <NavVertical openNav={nav.value} onCloseNav={nav.onFalse} />;

  useEffect(() => {
    if ((isSmallScreen && !isNavBarMinimized) || (!isSmallScreen && isNavBarMinimized)) {
      toggleNavBar();
    }
  // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isSmallScreen]);
  return (
    <>
      <Header/>

      <Box
        sx={{
          bgcolor : alpha(theme.palette.primary.main,0.1),
          minHeight: '100vh',
          display: 'flex',
          flexDirection: 'row',
        }}
      >
        {isNavBarMinimized ? renderNavMini : renderNavVertical}
        <Main>{children}</Main>
      </Box>
    </>
  );
}
