import { _noms } from '.';
import { EtatDemandeRecue } from '../types/absence';
import { TableColumn } from '../types/common';
import { DriverAbsenceStatus, IDriverAbsence } from '../types/driver-absence';
import { Departements } from '../types/etablissement';
import { BinaryQuestion } from '../types/trajet';
import { DRIVERS } from './_appointment';

export const _CHAUFFEURS = ['Anna Leblanc', 'Thomas Dubois', 'Marie Martin', 'Lucas Bernard'];
export const _TYPES_ABSENCE = ['Exceptionnelle', 'Autorisée', 'Maladie'];
export const _MODES_RECEPTION = ['Mail', 'Portail', 'SMS'];

export const _OPTION_DRIVER_ABSENCE = [
  { value: DriverAbsenceStatus.EnCours, label: 'En cours' },
  { value: DriverAbsenceStatus.NonTraite, label: 'Non traité' },
  { value: DriverAbsenceStatus.Valide, label: 'Validé' },
  { value: DriverAbsenceStatus.Rejete, label: 'Rejeté' },
];

export const _absencesDriver: IDriverAbsence[] = [...Array(20)].map((_, i) => {
  const START_DATE = new Date(2020 + Math.floor(i / 12), i % 12, 15);
  const END_DATE = new Date(START_DATE.getFullYear() + 2, Math.floor(Math.random() * 12), 1);
  const departementsArray = Object.values(Departements);
  const statusList = Object.values(DriverAbsenceStatus);
  return {
    id: (i + 1).toString(),
    chauffeur: _CHAUFFEURS[i % _CHAUFFEURS.length],
    typeAbsence: _TYPES_ABSENCE[i % _TYPES_ABSENCE.length],
    dateDebut: START_DATE.toISOString().split('T')[0],
    dateFin: END_DATE.toISOString().split('T')[0],
    chauffeurAffecte: i % 2 === 0 ? BinaryQuestion.Oui : BinaryQuestion.Non,
    modeReception: _MODES_RECEPTION[i % _MODES_RECEPTION.length],
    department: departementsArray[i % departementsArray.length],
    autorisePar: _noms[Math.floor(Math.random() * 5)],
    validePar: DRIVERS[i % DRIVERS.length].value,
    nombreHeures: Math.floor(Math.random() * 5).toString(),
    statut: statusList[Math.floor(Math.random() * statusList.length)],
  };
});

export const DEFAULT_ABSENCE_DRIVER_TABLE_HEAD = (isNonTraite: boolean): TableColumn[] => [
  { id: 'id', label: "N° d'enregistrement", type: 'text', align: 'center' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text' },
  { id: 'typeAbsence', label: "Type d'absence", type: 'text' },
  { id: 'dateDebut', label: 'Début', type: 'date', align: 'center' },
  { id: 'dateFin', label: 'Fin', type: 'date', align: 'center' },
  { id: 'chauffeurAffecte', label: 'Chauffeur Affecté', type: 'status' },
  { id: 'modeReception', label: 'Mode de réception', type: 'text' },
  { id: 'department', label: 'Département', type: 'text' },
  { id: 'nombreHeures', label: "Nombre d'heures", type: 'text', align: 'center' },
  { id: 'autorisePar', label: 'Autorisé Par', type: 'text', align: 'center' },
  { id: 'statut', label: 'Statut', type: 'status' },
  ...(isNonTraite ? [] : [{ id: 'validePar', label: 'Validé Par', type: 'text' }]),
  { id: 'justificatif', label: 'Justificatif', type: 'text' },
  { id: 'actions', label: 'Action', type: 'text' },
];

export const INITIAL_ABSENCE_DRIVER_DATA = (isNonTraite: boolean): IDriverAbsence => ({
  id: '',
  chauffeur: '',
  typeAbsence: '',
  dateDebut: '',
  dateFin: '',
  chauffeurAffecte: BinaryQuestion.Non,
  modeReception: 'Portail',
  department: Departements.Cher,
  nombreHeures: '',
  autorisePar: '',
  statut: isNonTraite ? DriverAbsenceStatus.NonTraite : DriverAbsenceStatus.Valide,
});
