import {LeaveType, LeaveStatus, IDemandeAbsence } from '@/shared/types/leave';



const _reuestNumber =["1234567890","1234567891","1234567892","1234567893","1234567894","1234567895","1234567896","1234567897","1234567898","1234567899"]

const _REASONS = [
  "Maladie nécessitant un repos",
  "Congé parental pour naissance",
  "Congés annuels planifiés",
  "Raisons personnelles",
  "RTT conventionnel"
];

const LEAVE_TYPES: LeaveType[] = [
  'Congé maladie',
  'Congé parental',
  'Congé annuel',
  'Congé sans solde',
  'RTT'
];

const LEAVE_STATUS: LeaveStatus[] = [
  'En attente',
  'Approuvée',
  'Refusée'
];


const calculateDays = (startDate: Date, endDate: Date): number => {
  const diffTime = Math.abs(endDate.getTime() - startDate.getTime());
  return Math.ceil(diffTime / (1000 * 60 * 60 * 24));
};



export const _absence: IDemandeAbsence[] = [...Array(30)].map((_, index) => {
  const submissionDate = new Date(2024, index % 12, Math.floor(Math.random() * 28) + 1);
  const startDate = new Date(submissionDate);
  startDate.setDate(startDate.getDate() + Math.floor(Math.random() * 14) + 1);
  const endDate = new Date(startDate);
  endDate.setDate(endDate.getDate() + Math.floor(Math.random() * 14) + 1);
  const processDate = new Date(submissionDate);
  processDate.setDate(processDate.getDate() + Math.floor(Math.random() * 3) + 1);
  
const requestNumber = _reuestNumber[index % _reuestNumber.length]
  const status = ['En attente', 'Approuvée', 'Refusée'][Math.floor(Math.random() * 3)] as LeaveStatus;
  
  const leaveType = LEAVE_TYPES[index % LEAVE_TYPES.length];
  

  return {
    id: (index + 1).toString(),
    requestNumber,
    submissionDate: submissionDate.toISOString().split('T')[0],
    leaveType,
    startDate: startDate.toISOString().split('T')[0],
    endDate: endDate.toISOString().split('T')[0],
    status,
    processDate: processDate.toISOString().split('T')[0],   
    reason: _REASONS[Math.floor(Math.random() * _REASONS.length)],
    daysCount: calculateDays(startDate, endDate),
    employeeId: `EMP-${index + 1}`,
    isActive: Math.random() > 0.5
  } as IDemandeAbsence;
});

export const INITIAL_LEAVE_DATA: IDemandeAbsence = {
  id: '',
  requestNumber: '',
  DemandeType: 'Absence',
  AbsenceType: 'Congé annuel',
  submissionDate: new Date().toISOString().split('T')[0],
  leaveType: 'Congé annuel',
  startDate: new Date().toISOString().split('T')[0],
  endDate: new Date().toISOString().split('T')[0],
  status: 'En attente',
  processDate: new Date().toISOString().split('T')[0],
  reason: '',
  daysCount: 0,
  employeeId: '',
  isActive: true
};

export const ABSENCE_TABLE_COLUMNS = [
  { id: 'requestNumber', label: 'Numéro de demande', type: 'text' },
  { id: 'submissionDate', label: 'Date de soumission', type: 'date' },
  { id: 'leaveType', label: 'Type de demande', type: 'text' },
  { id: 'startDate', label: 'Date de début', type: 'date' },
  { id: 'endDate', label: 'Date de fin', type: 'date' },
  { id: 'daysCount', label: 'Nombre de jours', type: 'number' },
  { id: 'status', label: 'Statut', type: 'status' },
  { id: 'processDate', label: 'Date de traitement', type: 'date' },
  { id: 'actions', label: 'Actions', type: 'actions' }
];