import { JoursAttribues } from "../types/chauffeur";
import { TableColumn } from "../types/common";
import { IAvenantUsager } from "../types/usager";

export const _avenants_usagers = [...Array(5)].map((_, index) => {
  const startDate = new Date(2020 + Math.floor(index / 12), index % 12, 15);
  return {
    id: (index + 1).toString(),
    numeroAvenant: `${(index+1).toString().padStart(5, '0')}`,
    dateApplication: startDate.toISOString().split('T')[0],
    codeCircuit: `CIR-2024-${String.fromCharCode(65 + (index % 26))}${String.fromCharCode(65 + (Math.floor(index / 26)))}`,
    intituleCircuit: `Avenant ${index + 1}`,
    objetAvenant: ["Adresse Domicile", "Horaires", "Véhicule", "Tarification"][index % 4],
    etablissement: ['les_champs', 'la_colline', 'le_rivage', 'la_foret'].slice(index % 4, index % 4 + 1),
    observation: ['Ce bus facilite les déplacements urbains.', 'Bus facilite les déplacements urbains.'][Math.floor(Math.random() * 2)],
    specificite: '',
    avenantTemporaire:''
  };
});
export const etablissementsOptions = [
  { label: 'Les Champs', value: 'les_champs' },
  { label: 'La Colline', value: 'la_colline' },
  { label: 'Le Rivage', value: 'le_rivage' },
  { label: 'La Forêt', value: 'la_foret' },
];

export const DEFAULT_AVENANT_USAGERS_TABLE_HEAD: TableColumn[] = [
  { id: 'numeroAvenant', label: 'N° Avenant', type: 'text' },
  { id: 'dateApplication', label: 'A partir du', type: 'date' },
  { id: 'objetAvenant', label: 'Objet de l\'avenant', type: 'text' },
  { id: 'codeCircuit', label: 'Code', type: 'text' },
  { id: 'intituleCircuit', label: 'Circuit', type: 'text' },
  { id: 'observation', label: 'Observation', type: 'text' },
];

export const createEmptyJoursAttribues = (): JoursAttribues => {
  return {
    pair: {
      lundi: { matin: false, soir: false },
      mardi: { matin: false, soir: false },
      mercredi: { matin: false, soir: false },
      jeudi: { matin: false, soir: false },
      vendredi: { matin: false, soir: false },
      samedi: { matin: false, soir: false },
      dimanche: { matin: false, soir: false },
    },
    impair: {
      lundi: { matin: false, soir: false },
      mardi: { matin: false, soir: false },
      mercredi: { matin: false, soir: false },
      jeudi: { matin: false, soir: false },
      vendredi: { matin: false, soir: false },
      samedi: { matin: false, soir: false },
      dimanche: { matin: false, soir: false },
    },
  }
}
export const INITIAL_AVENANT_USAGERS_DATA: IAvenantUsager = {
  id: '',
  numeroAvenant: '',
  dateApplication: '',
  codeCircuit: '',
  intituleCircuit: '',
  objetAvenant: '',
  specificite: '',
  avenantTemporaire: '',
  etablissement: [],
  jours: [createEmptyJoursAttribues()],
};
