import { IcircuitTrajet, Sens } from "../types/circuit";
import { TableColumn } from "../types/common";
import { faClock, faWheelchair } from "@fortawesome/free-solid-svg-icons";
import { EtatTrajet } from "../types/trajet";

const INTITULES = ['Lun - Mar 07:30', 'Mer-Jeu-Ven 8h', 'Lun 17h', 'Mar-Mer 18h','Jeu-Ven 17h:30'];
const USAGERS = ['Étudiants', 'Collégiens', 'Lycéens', 'Primaires'];
const ETS = ['Lycée Général', 'Collège', 'École Primaire', 'Lycée Professionnel'];
const CHAUFFEURS = ['Jean Dupont', 'Marie Martin', 'Pierre Bernard', 'Sophie Petit'];
const CIRCUITS = ['2211', '2212', '2213', '2214'];

export const _TRAJET_PRET = [
    { value: "oui", label: "Oui" },
    { value: "non", label: "Non" },
  ];
const getRandomItem = (array : string[]) => array[Math.floor(Math.random() * array.length)];

const generateKmAndTime = () => `${Math.floor(Math.random() * 200) + 100} km/3h`;


export const getTrajetPret = (status: string): string => {
  const statusObj = _TRAJET_PRET.find(s => s.value === status);
  return statusObj ? statusObj.label : "Inconnu";
};

export const _TRAJETS = [...Array(5)].map((_, index) => {
  const isPrimary = index % 2 === 0;
  const circuitCode = isPrimary ? 'EC-001' : 'SC-002';
  const startDate = new Date(2023 + Math.floor(index / 12), index % 12, 15);
  const usagersCount = Math.floor(Math.random() * 3) + 1
  const usagersList = Array(usagersCount)
    .fill(0)
    .map(() => getRandomItem(CHAUFFEURS))
  return {
    id: (index + 1).toString(),
    numeroTrajet: (index + 1).toString().padStart(6, '0'),
    preparation: Math.random() > 0.5 ? 'oui' : 'non',
    dateDebut: startDate.toISOString().split('T')[0],
    intitule: INTITULES[index],
    sensAR: index < 2  ? Sens.Aller : Sens.Retour, 
    kmEtTemps: generateKmAndTime(),
    usagers: usagersList,
    ets: getRandomItem(ETS),
    codeTrajetCircuit: `${circuitCode}-${(index + 1).toString().padStart(3, '0')}`,
    circuit: getRandomItem(CIRCUITS),
    etat: index % 3 === 0 ? EtatTrajet.Controle : EtatTrajet.NonControle,
    chauffeur: getRandomItem(CHAUFFEURS)
  };
});
export const DEFAULT_CIRCUIT_TRAJET_TABLE_HEAD: TableColumn[] = [
  { id: 'numeroTrajet', label: 'N° Trajet', type: 'text', align: 'center' },
  { id: 'preparation', label: 'Préparation', type: 'status', align: 'center' },
  { id: 'dateDebut', label: 'Date de début', type: 'date', align: 'center' },
  { id: 'intitule', label: 'Intitulé', type: 'text', align: 'left' },
  { id: 'sensAR', label: 'Sens (Aller/Retour)', type: 'text', align: 'center' },
  { id: 'kmEtTemps', label: 'Distance & Temps', type: 'text', align: 'center' },
  { id: 'usagers', label: 'Usagers', type: 'text', align: 'left' },
  { id: 'ets', label: 'Ets', type: 'text', align: 'left' },
  { id: 'codeTrajetCircuit', label: 'Code du trajet circuit', type: 'text', align: 'left' },
  { id: 'circuit', label: 'Circuit', type: 'text', align: 'left' },
  { id: 'etat', label: 'État', type: 'status', align: 'center' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text', align: 'left' },
  { id: '', label: 'Action' },
];

export const INITIAL_CIRCUIT_TRAJET_DATA: IcircuitTrajet = {
  id: '',
  numeroTrajet: '',
  preparation: 'non',
  dateDebut: '',
  intitule: '',
  sensAR: Sens.Aller,
  kmEtTemps: '',
  usagers: [],
  ets: '',
  codeTrajetCircuit: '',
  circuit: '',
  etat: EtatTrajet.NonControle,
  chauffeur: ''
};

//details circuit
export const passengers = [
    {
      name: 'Jean Dupont',
      schedule: 'Mer-Jeu-Ven 8h',
      phone: '+33 6 12 34 56 78',
      route: 'La Défense→Quartier Les ecoles (2 Km)',
      times: ['07:30 AM', '08:00 AM', '17:00 PM', '18:00 PM', '17:30 PM'],
      observation:
        'la propreté à bord des véhicules pourrait être améliorée pour offrir une meilleure expérience aux passagers.',
    },
    {
      name: 'Jean Dupont',
      schedule: 'Mer-Jeu-Ven 8h',
      phone: '+33 6 12 34 56 78',
      route: 'La Défense→Quartier Les ecoles (2 Km)',
      times: ['07:30 AM', '08:00 AM', '17:00 PM', '18:00 PM', '17:30 PM'],
      observation:
        'la propreté à bord des véhicules pourrait être améliorée pour offrir une meilleure expérience aux passagers.',
    },
  ];

export const summaryRows = [
    {
      label: 'kilomètre en charge',
      icon: '/assets/icons/menu/ic_exploitation.svg',
      values: [10, 10, 10, 10, 10],
      total: 'Total de kilomètre en charge: 60Km',
    },
    {
      label: 'Temps en charge',
      icon: faClock,
      values: [10, 10, 10, 10, 10],
      total: 'Total de kilomètre en charge: 60Km',
    },
    {
      label: 'Usagers en charge',
      icon: faWheelchair,
      values: [3, 3, 2, 1, 1],
      total: 'Total de Usagers en charge: 10Km',
    },
  ];
  export const timeSlots = [
    { id: '0000001', days: 'Lun - Mar', time: '07:30' },
    { id: '0000002', days: 'Mer-Jeu-Ven', time: '8h' },
    { id: '0000003', days: 'Lun', time: '17h' },
    { id: '0000004', days: 'Mar-Mer', time: '18h' },
    { id: '0000005', days: 'Jeu-Ven', time: '17h30' },
  ];

  