import { _noms, _prenoms } from "."
import { ScheduleData } from "../sections/chauffeur/planingChauffeur/types"
import { StatusColor } from "../sections/chauffeur/planingChauffeur/utils/schedule-utils"
import { TableColumn } from "../types/common"

const generateTimeSlot = () => {
    const startHour = Math.floor(Math.random() * 22)
    const startMinute = Math.floor(Math.random() * 4) * 15
  
    let endHour = startHour
    let endMinute = startMinute
  
    const duration = 30 + Math.floor(Math.random() * 90)
  
    endMinute += duration
    if (endMinute >= 60) {
      endHour += Math.floor(endMinute / 60)
      endMinute %= 60
    }
  
    return {
      startHeure: startHour.toString().padStart(2, "0"),
      startMinute: startMinute.toString().padStart(2, "0"),
      endHeure: endHour.toString().padStart(2, "0"),
      endMinute: endMinute.toString().padStart(2, "0"),
    }
  }

export const mockScheduleData: ScheduleData = {
  drivers: [
    { id: "1", name: "Non Affecté", company: "", vehicleId: "",immatricule:"" },
    ...Array.from({ length: 10 }, (_, index) => ({
      id: (index + 2).toString(),
      name: `${_prenoms[index % 4]} ${_noms[index % 4]}`,
      company: ["Citadine SP", "TransUrban", "MetroRide"][Math.floor(Math.random() * 3)],
      vehicleId: Math.floor(1000000 + Math.random() * 9000000).toString(),
      immatricule:""
    })),
  ],
  timeSlots: Array.from({ length: 30 }, (_, index) => {
    const { startHeure, startMinute, endHeure, endMinute } = generateTimeSlot()
    const date = new Date(2024, 0, 1 + index)
    return {
      id: (index + 1).toString(),
      driverId: Math.floor(Math.random() * 11 + 1).toString(),
      vehicleId: ['AA-123-BB', 'BB-456-CC', 'CC-789-DD', 'DD-101-EE'][Math.floor(Math.random() * 4)],
      startHeure,
      startMinute,
      endHeure,
      endMinute,
      date: date.toISOString().split("T")[0],
      color: Object.values(StatusColor)[Math.floor(Math.random() * 4)],
    }
  }),
}

export const Location_TABLE_COLUMNS : TableColumn[] =  [
  { id: "vehicleId", label: "Immatriculation", type: "text" },
  { id: "vehicleName", label: "Nom du véhicule", type: "text" },
  { id: "vehicleType", label: "Type de véhicule", type: "text" },
  { id: "supplier", label: "Fournisseur", type: "text" },
  { id: "startDate", label: "Date de début", type: "date" },
  { id: "endDate", label: "Date de fin", type: "date" },
  { id: "status", label: "Statut", type: "text" },
]

export const companyOptions = [
  { label: "Citadine SP", value: "Citadine SP" },
  { label: "TransUrban", value: "TransUrban" },
  { label: "MetroRide", value: "MetroRide" },
]

// Adding vehicle types for the rental planning
export const vehicleTypes = [
  "Berline", 
  "SUV", 
  "Utilitaire", 
  "Camionnette", 
  "Minibus"
]

// Adding rental status options
export const rentalStatusOptions = [
  { label: "En cours", value: "en_cours", color: StatusColor.INFO },
  { label: "Planifié", value: "planifie", color: StatusColor.PRIMARY},
  { label: "Terminé", value: "termine", color: StatusColor.SUCCESS },
  { label: "Problème", value: "probleme", color: StatusColor.WARNING },
]

// Adding suppliers for vehicle rentals
export const supplierOptions = [
  { label: "EuroCar", value: "EuroCar" },
  { label: "AutoLoc", value: "AutoLoc" },
  { label: "RentExpress", value: "RentExpress" },
  { label: "MobilityPlus", value: "MobilityPlus" },
]

// Mock data for vehicle rentals
export const mockVehicleRentalData = {
  vehicles: [
    { id: "1", vehicleImmatr: "Minibus",date:"" ,VehiculeName: "Mercedes", vehicleType: "Minibus", supplier: "AutoLoc" },
    { id: "2", vehicleImmatr: "Véhicule 010", VehiculeName: "Golf", vehicleType: "Camionnette", supplier: "AutoLoc" },
    { id: "3", vehicleImmatr: "Véhicule 011", VehiculeName: "Clio", vehicleType: "SUV", supplier: "AutoLoc" },
    { id: "4", vehicleImmatr: "Véhicule 008", VehiculeName: "Toyota", vehicleType: "Minibus", supplier: "MobilityPlus" },
    { id: "5", vehicleImmatr: "Véhicule 009", VehiculeName: "Hundei", vehicleType: "SUV", supplier: "MobilityPlus" },
    { id: "6", vehicleImmatr: "Véhicule 013", VehiculeName: "Fiat", vehicleType: "Camionnette", supplier: "MobilityPlus" },
    { id: "7", vehicleImmatr: "Véhicule 014", VehiculeName: "Citroen", vehicleType: "Berline", supplier: "MobilityPlus" },
    { id: "8", vehicleImmatr: "Véhicule 012", VehiculeName: "Dacia Logan", vehicleType: "Camionnette", supplier: "RentExpress" },
    { id: "9", vehicleImmatr: "Véhicule 015", VehiculeName: "Peugot", vehicleType: "Camionnette", supplier: "RentExpress" },
  ],
  
  rentalPeriods: [
    {
      id: "1",
      vehicleId: "2", // Golf
      startDate: "2025-04-09",
      endDate: "2025-04-11",
      status: "planifie",
      startHeure:"",
      endHeure:"",
      startMinute:"",
      endMinute:"",
      date:"2025-04-05",
      color: StatusColor.SUCCESS,
      hasStartLocation: true,
      hasEndLocation: true
    },
   
    {
        id: "new1",
        vehicleId: "3", // Clio
        startDate: "2025-04-09",
        endDate: "2025-04-15",
        status: "en_cours",
        startHeure:"",
        endHeure:"",
        startMinute:"",
        endMinute:"",
        color: StatusColor.INFO,
        hasStartLocation: true,
        hasEndLocation: true
      },
    {
      id: "2",
      vehicleId: "6", // Fiat
      startDate: "2025-04-10",
      endDate: "2025-04-12",
      status: "termine",
      color: StatusColor.WARNING,
      hasStartLocation: true,
      hasEndLocation: true
    },
    {
        id: "2",
        vehicleId: "6", // Fiat
        startDate: "2025-04-14",
        endDate: "2025-04-21",
        status: "termine",
        color: StatusColor.WARNING,
        hasStartLocation: true,
        hasEndLocation: true
      },
    {
      id: "3",
      vehicleId: "7", // Citroen
      startDate: "2025-04-14",
      endDate: "2025-04-16",
      status: "planifie",
      color: StatusColor.INFO,
      hasStartLocation: true,
      hasEndLocation: true
    },
    
    {
      id: "5",
      vehicleId: "8", // Dacia Logan
      startDate: "2025-04-17",
      endDate: "2025-04-19",
      status: "termine",
      color: StatusColor.WARNING,
      hasStartLocation: true,
      hasEndLocation: true
    },
    {
        id: "5",
        vehicleId: "8", // Dacia Logan
        startDate: "2025-04-09",
        endDate: "2025-04-19",
        status: "termine",
        color: StatusColor.SUCCESS,
        hasStartLocation: true,
        hasEndLocation: true
      },
    {
      id: "6",
      vehicleId: "9", // Peugot
      startDate: "2025-04-19",
      endDate: "2025-04-21",
      status: "en_cours",
      color: StatusColor.INFO,
      hasStartLocation: true,
      hasEndLocation: true
    }, {
        id: "6",
        vehicleId: "9", // Peugot
        startDate: "2025-04-22",
        endDate: "2025-04-25",
        status: "en_cours",
        color: StatusColor.INFO,
        hasStartLocation: true,
        hasEndLocation: true
      }
  ]
};

// Update the vehicleToDriverData object to ensure dates are in the correct format
const vehicleToDriverData: ScheduleData = {
  drivers: mockVehicleRentalData.vehicles.map(vehicle => ({
    id: vehicle.id,
    name: vehicle.VehiculeName,
    company: vehicle.vehicleType,
    immatricule: vehicle.vehicleImmatr,
    vehicleId: vehicle.supplier,
  })),
  timeSlots: mockVehicleRentalData.rentalPeriods.map(rental => {
    // Ensure dates are in the correct format
    const startDate = rental.startDate || '2025-04-01';
    const endDate = rental.endDate || '2025-04-02';
    
    return {
      id: rental.id,
      driverId: rental.vehicleId,
      vehicleId: rental.vehicleId,
      startDate: startDate,
      endDate: endDate,
      date: rental.date || startDate, // Default to startDate if date is undefined
      startHeure: rental.startHeure || '08', // Default start hour
      endHeure: rental.endHeure || '17', // Default end hour
      startMinute: rental.startMinute || '00', // Default start minute
      endMinute: rental.endMinute || '00', // Default end minute
      color: rental.color,
      hasStartLocation: rental.hasStartLocation || false,
      hasEndLocation: rental.hasEndLocation || false,
      status: rental.status || 'planifie',
    };
  }),
};

export { vehicleToDriverData };