import { Sens } from "../types/circuit";
import { AddressData } from "../types/common";
import { Departements } from "../types/etablissement";

export const users = [
  {
    id: '8864c717-587d-472a-929a-8e5f298024da-2',
    displayName: 'admin',
    email: 'admin@vsn.com',
    password: 'admin1234',
  }
];

export const getLabel = (value: string, options: { label: string; value: string }[]) => {
  const option = options.find((opt) => opt.value === value)
  return option ? option.label : value
}

export const _noms = ['Dupont', 'Durand', 'Morel', 'Laurent'];
export const _prenoms = ['Jean', 'Marie', 'Pierre', 'Sophie'];
export const generatePhoneNumber = (prefix: string) =>
  `${prefix}${Math.floor(100000000 + Math.random() * 900000000)}`;
export const generateStartDate = (index: number, baseYear = 2025): string => {
  const date = new Date(baseYear, Math.floor(index / 10), 1 + (index % 28))
  return date.toISOString().split("T")[0]
}
export const generateEndDate = (startDate: string, durationDays = 7): string => {
  const date = new Date(startDate)
  date.setDate(date.getDate() + durationDays)
  return date.toISOString().split("T")[0]
}
export const generateDateRange = (
  index: number,
  durationDays = 7,
  baseYear = 2025,
): { startDate: string; endDate: string } => {
  const startDate = generateStartDate(index, baseYear)
  const endDate = generateEndDate(startDate, durationDays)

  return { startDate, endDate }
}

export const getDepartement = (index: number): Departements => {
  const departements = Object.values(Departements);
  return departements[index % departements.length];
};

export const _SENS_AR = [
  { value: Sens.Aller, label: "Aller" },
  { value: Sens.Retour, label: "Retour" },
];

export const ADRESSE = ["45 Rue de l'Education, France", "12 Boulevard des Sciences, France", "7 Place de la République, France", "23 Rue des Arts, France"];
export const ETS_NAMES = ["L'Élégance Bistro", "Collège Saint-Michel", "École Primaire Jean Moulin", "Lycée International"]
export const IMMATRICULATIONS = ["AB-123-CD", "EF-456-GH", "IJ-789-KL", "MN-012-OP", "QR-345-ST", "UV-678-WX"];
export const AGENCY = [
  "Adanev",
  "Adanev VAR",
  "Île-de-France",
  "Lyon",
  "Gironde",
  "Sarthe",
  "Drome",
  "Côtes-d Armor",
  "Deux-Sèvres",
  "Corrèze",
  "Ardèche",
  "Bouches du rhone",
];
export const _MARQUES = ['Audi', 'Mercedes', 'Renault', 'Peugeot', 'Citroën', 'Volkswagen'];
export const _MODELES = ['Version 1.0', 'Version 2.0', 'Sprinter', 'Trafic', 'Expert', 'Crafter'];
export const _petrolier = ['DKV', 'TOTAL'];
export const FUEL_CARDS = ["C309348", "D405672", "B708934", "A203456"];
export const FUEL_CARDS_OPTIONS = FUEL_CARDS.map(fuel => ({
  value: fuel,
  label: fuel.charAt(0).toUpperCase() + fuel.slice(1)
}));
export const FUEL_TYPES = [
  { value: 'gasoil', label: 'Gasoil' },
  { value: 'essence', label: 'Essence' },
  { value: 'gpl', label: 'Gaz de Pétrole Liquéfié' },
  { value: 'electrique', label: 'Électrique' },
  { value: 'hybride', label: 'Hybride' },
]
export const MOCK_ADDRESSES: AddressData[] = [
  {
    address: "10 Rue de la Paix",
    lat: 48.86982,
    lng: 2.33172,
    city: "Paris",
    postalCode: "75002",
    country: "France",
    formattedAddress: "10 Rue de la Paix, 75002 Paris, France"
  },
  {
    address: "20 Rue de la République",
    lat: 45.76404,
    lng: 4.83566,
    city: "Lyon",
    postalCode: "69002",
    country: "France",
    formattedAddress: "20 Rue de la République, 69002 Lyon, France"
  },
  {
    address: "30 Canebière",
    lat: 43.29648,
    lng: 5.36978,
    city: "Marseille",
    postalCode: "13001",
    country: "France",
    formattedAddress: "30 La Canebière, 13001 Marseille, France"
  },
  {
    address: "40 Cours de l'Intendance",
    lat: 44.84399,
    lng: -0.57341,
    city: "Bordeaux",
    postalCode: "33000",
    country: "France",
    formattedAddress: "40 Cours de l'Intendance, 33000 Bordeaux, France"
  }
];
export const fileTypes = ["PDF", "word", "excel", "IMAGE"]

export const INITIAL_ADDRESS: AddressData = {
    address: '',
    lat: 0,
    lng: 0,
    city: '',
    postalCode: '',
    country: '',
    formattedAddress: ''
};