// endpoints/absence-service.ts

const endpointPrefix = '/api/absence';

export const absenceEndpoints = {
  absence: {
    attendanceSheet: {
      searchAttendanceSheets: `${endpointPrefix}/attendance-sheet/search`,
      getAttendanceSheetById: (id: string) => `${endpointPrefix}/attendance-sheet/${id}`, 
      createAttendanceSheet: `${endpointPrefix}/attendance-sheet/create`, 
      updateAttendanceSheet: (id: string) => `${endpointPrefix}/attendance-sheet/update/${id}`, 
      toggleStatus: (id: string) => `${endpointPrefix}/attendance-sheet/${id}/toggle-status`, 
      exportAttendanceSheets: `${endpointPrefix}/attendance-sheet/export`, 
      updateStatus: (id: string, status: string) => `${endpointPrefix}/attendance-sheet/${id}/status?status=${status}`, 
    },

  },
};