const endpointPrefix = "/api/document";

export const documentEndpoints = {
  Folder: {
    create: endpointPrefix + "/folders/create",
    rename: (folderId: number, newName: string, ownerId: number) =>
  `${endpointPrefix}/folders/rename/${folderId}?newName=${encodeURIComponent(newName)}&ownerId=${ownerId}`,
    delete: (folderId: number, ownerId : number) => `${endpointPrefix}/folders/delete/${folderId}?ownerId=${ownerId}`,
    getById: (folderId: number) => `${endpointPrefix}/folders/${folderId}`,
    getUserRootFolders: (ownerId: number) => `${endpointPrefix}/folders/root/${ownerId}`,
    getUserAllFolders: (ownerId: number) => `${endpointPrefix}/folders/all/${ownerId}`,
    move: endpointPrefix + "/folders/move",
    bulkMove: endpointPrefix + "/folders/bulk/move",
    bulkDelete: endpointPrefix + "/folders/bulk/delete",
    bulkShare: endpointPrefix + "/folders/bulk/share",
    share: endpointPrefix + "/folders/share",
    favorite: (folderId: number) => `${endpointPrefix}/folders/favorite/${folderId}`,
    unfavorite: (folderId: number) => `${endpointPrefix}/folders/unfavorite/${folderId}`,
    getFavorites: (ownerId: number) => `${endpointPrefix}/folders/favorites/${ownerId}`,
    search: endpointPrefix + "/folders/search",
    advancedSearch: endpointPrefix + "/folders/advanced-search",
    getDetails: (folderId: number) => `/api/document/folders/details/${folderId}`,
    downloadZip: (folderId: number) => `${endpointPrefix}/folders/download?folderId=${folderId}`,
  },

  Document: {
    upload: endpointPrefix + "/docs/upload",
    getById: (docId: number) => `${endpointPrefix}/docs/${docId}`,
    getUserDocuments: (ownerId: number) => `${endpointPrefix}/docs/user/${ownerId}`,
    getRootDocuments: (ownerId: number) => `${endpointPrefix}/docs/root/${ownerId}`,
    delete: (docId: number) => `${endpointPrefix}/docs/delete/${docId}`,
    bulkDelete: endpointPrefix + "/docs/bulk/delete",
    move: endpointPrefix + "/docs/move",
    bulkMove: endpointPrefix + "/docs/bulk/move",
    share: endpointPrefix + "/docs/share",
    bulkShare: endpointPrefix + "/docs/bulk/share",
    downloadUrl: (docId: number, ownerId: number) => `${endpointPrefix}/docs/download-url/${docId}?ownerId=${ownerId}`,
    downloadStream: (docId: number, ownerId: number) => `${endpointPrefix}/docs/download/${docId}?ownerId=${ownerId}`,
    favorite: (docId: number) => `${endpointPrefix}/docs/favorite/${docId}`,
    unfavorite: (docId: number) => `${endpointPrefix}/docs/unfavorite/${docId}`,
    getFavorites: (ownerId: number) => `${endpointPrefix}/docs/favorites/${ownerId}`,
    search: endpointPrefix + "/docs/search",
    advancedSearch: endpointPrefix + "/docs/advanced-search",
    statistics: (ownerId: number) => `${endpointPrefix}/docs/statistics/${ownerId}`
  },

  Storage: {
    getQuotaInfo: (ownerId: number) => `${endpointPrefix}/storage/quota/${ownerId}`,
    isQuotaExceeded: (ownerId: number) => `${endpointPrefix}/storage/quota-exceeded/${ownerId}`,
    getUsed: (ownerId: number) => `${endpointPrefix}/storage/used/${ownerId}`,
    getAvailable: (ownerId: number) => `${endpointPrefix}/storage/available/${ownerId}`
  }
};
