import React, { useState } from "react";
import Draggable from "react-draggable";
import { Box, IconButton, Typography } from "@mui/material";
import { useBoolean } from "@/hooks";
import SvgColor from "../svg-color";
import { common } from "@/shared/theme/palette";
import { useTheme } from '@mui/material/styles';

export default function Chatbot() {
  const isHovered = useBoolean(false);
  const theme = useTheme();

  return (
    <Draggable>
      <Box
        component="span"
        sx={{
          bgcolor: "transparent",
          position: "fixed",
          bottom: 140,
          right: 5,
          cursor: "move",
          zIndex: theme.zIndex.appBar + 2,
        }}
      >
        <IconButton
          onMouseEnter={isHovered.onTrue}
          onMouseLeave={isHovered.onFalse}
          sx={{
            bgcolor: (theme) => theme.palette.primary.main,
            "&:hover": {
              bgcolor: (theme) => theme.palette.secondary.main,
            },
            borderRadius: 4,
            transition: "all 0.4s ease-in-out",
            width: isHovered.value ? "auto" : "40px",
            height: "40px",
            display: "flex",
            alignItems: "center",
            justifyContent: "flex-start",
            padding: isHovered.value ? "8px 16px" : "8px",
            overflow: "hidden",
          }}
        >
          <SvgColor
            src="/assets/icons/ic_chatbot.svg"
            sx={{
              color: common.white,
              minWidth: "24px",
              minHeight: "24px",
              marginRight: isHovered.value ? "8px" : "0",
            }}
          />
          <Typography
            variant="body2"
            sx={{
              fontFamily: "Inter-Regular, Helvetica, Arial, sans-serif",
              fontWeight: "normal",
              color: common.white,
              fontSize: "0.875rem",
              opacity: isHovered.value ? 1 : 0,
              transition: "opacity 0.4s ease-in-out",
              whiteSpace: "nowrap",
              maxWidth: isHovered.value ? "200px" : "0",
              overflow: "hidden",
            }}
          >
            Besoin d&apos;aide ?
          </Typography>
        </IconButton>
      </Box>
    </Draggable>
  );
}