import ConfirmDialog, { ConfirmDialogProps } from './confirmDialog';

export const UnsavedChangesDialog = (props: Omit<ConfirmDialogProps, 'title' | 'content' | 'confirmButtonText' | 'cancelButtonText'>) => (
  <ConfirmDialog
    {...props}
    title="Modifications non sauvegardées"
    content="Des modifications non sauvegardées seront perdues si vous fermez cet onglet. Voulez-vous continuer ?"
    confirmButtonText="Fermer sans sauvegarder"
    cancelButtonText="Annuler"
    confirmButtonColor="error"
  />
);