"use client"

import { Avatar } from "@mui/material";
import { AddButton } from "@/shared/components/table/styles";
import FontAwesome from "@/shared/components/fontawesome";
import { faUser } from "@fortawesome/free-solid-svg-icons";
import SvgColor from "@/shared/components/svg-color";
import { Box } from '@mui/system';

interface AvatarUploaderProps {
    onUpload?: () => void;
    isReadOnly?:boolean;
  }
  
  export default function AvatarUploader({ onUpload, isReadOnly }: AvatarUploaderProps) {
  return (
    <Box  display= "flex" justifyContent="flex-start" flexDirection="row" alignItems= "end" gap={4} >

      <Avatar
        sx={{
          width: 88,
          height: 88,
          bgcolor: 'grey.300',
          border: (theme) => `solid 1px ${theme.palette.grey[300]}`,
        }}
      >
        <FontAwesome icon={faUser} width={60} sx={{ color: 'grey.500' }} />
      </Avatar>
        <AddButton
          sx={{ p: 1 }}
          variant="contained"
          endIcon={<SvgColor src="/assets/icons/form/ic_upload.svg" sx={{ width: '15px' }} />}
          onClick={onUpload}
          disabled={isReadOnly}
        >
          Importez une photo
        </AddButton>
    </Box>
  );
}
