"use client"
import { Table, TableHead, TableBody, TableCell, Typography, TableRow, IconButton } from "@mui/material"
import FontAwesome from "@/shared/components/fontawesome"
import { faClock, faMapLocationDot } from "@fortawesome/free-solid-svg-icons"
import { Box } from "@mui/system"
import { useState } from "react"

import { StyledTableContainer } from "@/shared/theme/css"
import { pxToRem } from "@/shared/theme/typography"
import { HeaderCell, StyledTableRow } from "@/shared/components/form/style"
import { dateFormat, formatDate } from "@/utils/format-time"
import SvgColor from "@/shared/components/svg-color"
import { lightColor } from "@/shared/components/table/styles"
import CustomTooltip from "@/shared/components/tooltips/tooltip-custom"
import { BaseStyledRow, TrajetStyledRow } from "@/shared/sections/contract/styles"
import { VerificationTableType } from "./weekly-verification-panel"
import VsnScheduleModal from "@/shared/sections/chauffeur/roadmap/components/validate-roadmap/vsn-schedule-modal/vsn-schedule-modal"

interface Column {
  id: string
  label: string
  align?: "left" | "center" | "right"
}

interface ScheduleVerificationTableProps {
  title: string
  columns: Column[]
  data: any[]
  VerificationType: VerificationTableType
  maxHeight?: string | number
}

export default function ScheduleVerificationTable({
  title,
  columns,
  data,
  VerificationType,
  maxHeight = "486px",
}: ScheduleVerificationTableProps) {
  const [modalOpen, setModalOpen] = useState(false)
  const [selectedRow, setSelectedRow] = useState<any>(null)

  const handleOpenModal = (row: any) => {
    setSelectedRow(row)
    setModalOpen(true)
  }

  const handleCloseModal = () => {
    setModalOpen(false)
  }

  const isGeolocation = VerificationType === VerificationTableType.geolocation
  const renderCellContent = (columnId: string, value: any, row: any) => {
    switch (columnId) {
      case "firstPickUp":
      case "lastDropOff":
      case "homeArrival":
      case "homeDeparture":
        return (
          <Box
            sx={{
              whiteSpace: "nowrap",
            }}
            display="flex"
            alignItems="center"
          >
            {columnId === "firstPickUp" ? (
              <SvgColor
                src="/assets/icons/menu/ic_exploitation.svg"
                sx={{ color: "primary.main", width: 12, height: 12 }}
              />
            ) : (
              <FontAwesome icon={faClock} color="primary.main" width={12} />
            )}
            <Typography variant="caption" sx={{ ml: 1 }}>
              {value || "08:00 AM"}
            </Typography>
          </Box>
        )
      case "date":
        return formatDate(value, dateFormat.isoDate)
      case "carte":
        return (
          <CustomTooltip title={"Afficher la carte"} arrow>
            <IconButton sx={lightColor} onClick={() => handleOpenModal(row)}>
              <FontAwesome icon={faMapLocationDot} color="primary.main" width={14} />
            </IconButton>
          </CustomTooltip>
        )
      default:
        return value
    }
  }

  const renderRow = (row: any, index: number) => {
    return (
      <TrajetStyledRow key={index}>
        {columns.map((column) => (
          <TableCell key={column.id} align={column.align} sx={{ whiteSpace: "nowrap", py: 1.6 }}>
            {renderCellContent(column.id, row[column.id as keyof typeof row], row)}
          </TableCell>
        ))}
      </TrajetStyledRow>
    )
  }

  const fontSize = pxToRem(13)

  return (
    <>
      <StyledTableContainer
        sx={{
          maxHeight: maxHeight,
        }}
      >
        <Table stickyHeader>
          <TableHead>
            <TableRow sx={{ bgcolor: "white" }}>
              <TableCell
                colSpan={columns.length}
                align="center"
                sx={{ fontWeight: "bold", color: "primary.main", position: "sticky" }}
              >
                {title || "Planning VSN"}
              </TableCell>
            </TableRow>
            <BaseStyledRow>
              {columns.map((headCell) => (
                <HeaderCell
                  sx={{
                    fontSize: fontSize,
                    position: "sticky",
                    top: 57,
                    backgroundColor: "primary.lighter",
                    py: 1.5,
                  }}
                  key={headCell.id}
                >
                  {headCell.label}
                </HeaderCell>
              ))}
            </BaseStyledRow>
          </TableHead>
          <TableBody>{data.map((row, index) => renderRow(row, index))}</TableBody>
        </Table>
      </StyledTableContainer>

      <VsnScheduleModal open={modalOpen} onClose={handleCloseModal} />
    </>
  )
}

